/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans.typed;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanListProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanMapProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanSetProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanListProperty;
import org.eclipse.core.internal.databinding.beans.BeanListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanSetProperty;
import org.eclipse.core.internal.databinding.beans.BeanSetPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanValuePropertyDecorator;

public class BeanProperties {
    public static <S, T> IBeanValueProperty<S, T> value(String propertyName) {
        return BeanProperties.value(null, propertyName, null);
    }

    public static <S, T> IBeanValueProperty<S, T> value(String propertyName, Class<T> valueType) {
        return BeanProperties.value(null, propertyName, valueType);
    }

    public static <S, T> IBeanValueProperty<S, T> value(Class<S> beanClass, String propertyName) {
        return BeanProperties.value(beanClass, propertyName, null);
    }

    public static <S, T> IBeanValueProperty<S, T> value(Class<S> beanClass, String propertyName, Class<T> valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        String[] propertyNames = BeanProperties.split(propertyName);
        if (propertyNames.length > 1) {
            valueType = null;
        }
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanValueProperty(propertyNames[0], valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyNames[0]);
            property = new BeanValueProperty(propertyDescriptor, valueType);
        }
        IBeanValueProperty beanProperty = new BeanValuePropertyDecorator(property, propertyDescriptor);
        int i = 1;
        while (i < propertyNames.length) {
            beanProperty = beanProperty.value(propertyNames[i]);
            ++i;
        }
        return beanProperty;
    }

    private static String[] split(String propertyName) {
        int index;
        if (propertyName.indexOf(46) == -1) {
            return new String[]{propertyName};
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        while ((index = propertyName.indexOf(46)) != -1) {
            propertyNames.add(propertyName.substring(0, index));
            propertyName = propertyName.substring(index + 1);
        }
        propertyNames.add(propertyName);
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    public static <S, T> IBeanValueProperty<S, T>[] values(Class<S> beanClass, String ... propertyNames) {
        IBeanValueProperty[] properties = new IBeanValueProperty[propertyNames.length];
        int i = 0;
        while (i < properties.length) {
            properties[i] = BeanProperties.value(beanClass, propertyNames[i], null);
            ++i;
        }
        return properties;
    }

    public static <S, T> IBeanValueProperty<S, T>[] values(String ... propertyNames) {
        return BeanProperties.values(null, propertyNames);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName) {
        return BeanProperties.set(null, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName, Class<E> elementType) {
        return BeanProperties.set(null, propertyName, elementType);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<S> beanClass, String propertyName) {
        return BeanProperties.set(beanClass, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanSetProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanSetProperty(propertyDescriptor, elementType);
        }
        return new BeanSetPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName) {
        return BeanProperties.list(null, propertyName, null);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName, Class<E> elementType) {
        return BeanProperties.list(null, propertyName, elementType);
    }

    public static <S, E> IBeanListProperty<S, E> list(Class<S> beanClass, String propertyName) {
        return BeanProperties.list(beanClass, propertyName, null);
    }

    public static <S, E> IBeanListProperty<S, E> list(Class<S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanListProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanListProperty(propertyDescriptor, elementType);
        }
        return new BeanListPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName) {
        return BeanProperties.map(null, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName, Class<K> keyType, Class<V> valueType) {
        return BeanProperties.map(null, propertyName, keyType, valueType);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<S> beanClass, String propertyName) {
        return BeanProperties.map(beanClass, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<S> beanClass, String propertyName, Class<K> keyType, Class<V> valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanMapProperty(propertyName, keyType, valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanMapProperty(propertyDescriptor, keyType, valueType);
        }
        return new BeanMapPropertyDecorator(property, propertyDescriptor);
    }
}

