/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class DBNFileSystemRoot
extends DBNPathBase
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNFileSystemRoot.class);
    private DBFVirtualFileSystemRoot root;
    private Path path;

    public DBNFileSystemRoot(DBNFileSystem parentNode, DBFVirtualFileSystemRoot root) {
        super(parentNode);
        this.root = root;
    }

    @NotNull
    public DBFVirtualFileSystemRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isDisposed() {
        return this.root == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.root = null;
        super.dispose(reflect);
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    @NotNull
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name() + ".folder";
    }

    @Override
    @NotNull
    public String getNodeTypeLabel() {
        return ModelMessages.fs_folder;
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    @NotNull
    public String getNodeDisplayName() {
        return this.root.getName();
    }

    @Override
    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FOLDER_CONSTRAINT;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.path = null;
        return super.refreshNode(monitor, source);
    }

    @Override
    public synchronized Path getPath() {
        if (this.path == null) {
            try {
                this.path = this.root.getRootPath(new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error("Error resolving file system root", e);
                this.path = Path.of(".nonexistentfolder", new String[0]);
            }
        }
        return this.path;
    }

    @Override
    protected synchronized void setPath(Path path) {
        this.path = path;
    }

    @Override
    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter.isInstance(this.root)) {
            return adapter.cast(this.root);
        }
        return super.getAdapter(adapter);
    }

    @Override
    @NotNull
    public String toString() {
        return this.root.getRootId() + "@" + this.root.getFileSystem().getId() + "->" + super.toString();
    }
}

