"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
exports.execute = execute;
const common_js_1 = require("./common.js");
function create(edgeOffsets, changeEdgesTo, graphOffset, changeFromGraph, changeGraphTo) {
    const toGraph = (0, common_js_1.getGraphKeywordStr)(changeGraphTo);
    const title = changeGraphTo === changeFromGraph
        ? `Fix all edges to match ${toGraph}`
        : `Convert ${(0, common_js_1.getGraphKeywordStr)(changeFromGraph)} to ${toGraph}`;
    const edgeStr = (0, common_js_1.getEdgeStr)(changeEdgesTo);
    return {
        title,
        command: "DOT.convertGraphType",
        arguments: [edgeOffsets, edgeStr, graphOffset, toGraph],
    };
}
function execute(doc, _sourceFile, cmd) {
    if (!isChangeAllOtherEdgeOpsAndFixGraphCommand(cmd))
        return undefined;
    const [edgeOffsets, changeEdgeTo, graphOffset, changeGraphTo] = cmd.arguments;
    const edits = edgeOffsets.map(o => {
        const startPos = doc.positionAt(o.start);
        const endPos = doc.positionAt(o.end);
        return (0, common_js_1.createChangeToEdit)(startPos, endPos, changeEdgeTo);
    });
    const graphStart = doc.positionAt(graphOffset.start);
    const graphEnd = doc.positionAt(graphOffset.end);
    edits.push((0, common_js_1.createChangeToEdit)(graphStart, graphEnd, changeGraphTo));
    return {
        label: `Convert graph to "${changeGraphTo}"`,
        edit: {
            changes: {
                [doc.uri]: edits,
            },
        },
    };
}
function isChangeAllOtherEdgeOpsAndFixGraphCommand(cmd) {
    return (cmd.command === "DOT.convertGraphType" && !!cmd.arguments && cmd.arguments.length === 4);
}
//# sourceMappingURL=ChangeAllOtherEdgeOpsAndFixGraphCommand.js.map