"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createChangeToEdit = createChangeToEdit;
exports.getEdgeStr = getEdgeStr;
exports.getGraphKeywordStr = getGraphKeywordStr;
exports.getOppositeKind = getOppositeKind;
exports.getOppositeEdgeOp = getOppositeEdgeOp;
exports.getAllowedOp = getAllowedOp;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const index_js_1 = require("../../index.js");
function createChangeToEdit(start, end, changeTo) {
    return vscode_languageserver_types_1.TextEdit.replace(vscode_languageserver_types_1.Range.create(start, end), changeTo);
}
function getEdgeStr(op) {
    return op === index_js_1.SyntaxKind.DirectedEdgeOp ? "->" : "--";
}
function getGraphKeywordStr(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword ? "digraph" : "graph";
}
function getOppositeKind(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword ? index_js_1.SyntaxKind.GraphKeyword : index_js_1.SyntaxKind.DigraphKeyword;
}
function getOppositeEdgeOp(g) {
    return g === index_js_1.SyntaxKind.DirectedEdgeOp
        ? index_js_1.SyntaxKind.UndirectedEdgeOp
        : index_js_1.SyntaxKind.DirectedEdgeOp;
}
function getAllowedOp(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword
        ? index_js_1.SyntaxKind.DirectedEdgeOp
        : index_js_1.SyntaxKind.UndirectedEdgeOp;
}
//# sourceMappingURL=common.js.map