"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStart = getStart;
exports.syntaxNodesToRanges = syntaxNodesToRanges;
exports.syntaxNodeToRange = syntaxNodeToRange;
exports.escapeIdentifierText = escapeIdentifierText;
exports.assertNever = assertNever;
const scanner_js_1 = require("../scanner.js");
const types_js_1 = require("../types.js");
function getStart(sourceFile, node) {
    return getTokenPosOfNode(sourceFile, node);
}
function getTokenPosOfNode(sourceFile, node) {
    if (nodeIsMissing(node))
        return node.pos;
    return (0, scanner_js_1.skipTrivia)(sourceFile.content, node.pos);
}
function nodeIsMissing(node) {
    return node === undefined
        ? true
        : node.pos === node.end && node.pos >= 0 && node.kind !== types_js_1.SyntaxKind.EndOfFileToken;
}
function syntaxNodesToRanges(doc, sourceFile, nodes) {
    return nodes.map(node => syntaxNodeToRange(doc, sourceFile, node));
}
function syntaxNodeToRange(doc, sourceFile, node) {
    const start = getStart(sourceFile, node);
    return {
        start: doc.positionAt(start),
        end: doc.positionAt(node.end),
    };
}
function escapeIdentifierText(text) {
    if (text === "")
        return quote("");
    if (text.includes('"') || text.includes("\n")) {
        const esc = text.replace(/"/, '\\"').replace(/\n/, "\\\n");
        return quote(esc);
    }
    const ch = text.charCodeAt(0);
    if (!(0, scanner_js_1.isIdentifierStart)(ch) || text.includes(" "))
        return quote(text);
    return text;
}
const quote = (s) => `"${s}"`;
function assertNever(v) {
    throw new Error(`Should not have reached this. Value: ${v !== null && v !== void 0 ? v : ""}`);
}
//# sourceMappingURL=util.js.map