define(["exports","./../modules/emby-apiclient/connectionmanager.js","./../modules/viewmanager/basesettingsview.js","./../modules/common/globalize.js","./../modules/common/servicelocator.js","./../modules/common/pluginmanager.js","./../modules/emby-elements/emby-scroller/emby-scroller.js","./../modules/emby-elements/emby-select/emby-select.js","./../modules/emby-elements/emby-button/emby-button.js","./../modules/emby-elements/emby-input/emby-input.js","./../modules/emby-elements/emby-toggle/emby-toggle.js","./../modules/emby-elements/emby-slider/emby-slider.js","./../modules/emby-elements/emby-premierecontainer/emby-premierecontainer.js"],function(_exports,_connectionmanager,_basesettingsview,_globalize,_servicelocator,_pluginmanager,_embyScroller,_embySelect,_embyButton,_embyInput,_embyToggle,_embySlider,_embyPremierecontainer){function normalizeCardSize(cardSize){switch(cardSize){case"normal":case"default":return"";default:return cardSize}}function fillStartupBehavior(context){var apiClient=_connectionmanager.default.currentApiClient();return function(apiClient){return!apiClient||!_servicelocator.appHost.supports("multiserver")||_connectionmanager.default.isLoggedIntoConnect()?Promise.resolve([]):_connectionmanager.default.getSignedInUsers(apiClient)}(apiClient).then(function(signedInUsers){var selectStartupBehavior=context.querySelector(".selectStartupBehavior"),html="";if(html+='<option value="lastuser">'+_globalize.default.translate("RememberLastUser")+"</option>",apiClient&&!_connectionmanager.default.isLoggedIntoConnect())for(var i=0,length=signedInUsers.length;i<length;i++){var user=signedInUsers[i];html+='<option value="'+(apiClient.serverId()+"|"+user.Id)+'">'+_globalize.default.translate("SignInAsValue",user.Name)+"</option>"}html+='<option value="showlogin">'+_globalize.default.translate("ShowLoginScreen")+"</option>",selectStartupBehavior.innerHTML=html})}function fillLanguages(select){for(var options=select.options,displayNames=new Intl.DisplayNames(_globalize.default.getCurrentLocales(),{type:"language",fallback:"none",languageDisplay:"standard"}),i=0,length=options.length;i<length;i++){var option=options[i],code=option.value;if(code)try{var displayName=displayNames.of(code);displayName&&(option.innerHTML=displayName)}catch(err){console.log("error thrown by Intl.DisplayNames: "+err+". Code: "+code)}}}function View(view,params){_basesettingsview.default.apply(this,arguments);var formatter,select,key,options={element:view.querySelector(".settingsContainer")};this.settingsOptions=options,select=view.querySelector(".selectSlidehowInterval"),formatter=new Intl.DurationFormat(_globalize.default.getCurrentLocales(),{style:"long"}),select.innerHTML=[5,10,15,20,25,30].map(function(option){return{name:formatter.format({seconds:option}),value:1e3*option}}).map(function(o){return'<option value="'+o.value+'">'+o.name+"</option>"}).join(""),function(context){var context=context.querySelector(".selectScreensaver"),options=_pluginmanager.default.ofType("screensaver").map(function(plugin){return{name:plugin.name,value:plugin.id}});options.unshift({name:_globalize.default.translate("None"),value:"none"}),context.innerHTML=options.map(function(o){return'<option value="'+o.value+'">'+o.name+"</option>"}).join("")}(view),function(context){var context=context.querySelector(".selectSoundEffects"),options=_pluginmanager.default.ofType("soundeffects").map(function(plugin){return{name:plugin.name,value:plugin.id}});options.unshift({name:_globalize.default.translate("None"),value:"none"}),context.innerHTML=options.map(function(o){return'<option value="'+o.value+'">'+o.name+"</option>"}).join("")}(view),fillLanguages(view.querySelector(".selectLanguage")),fillLanguages(view.querySelector(".selectDateTimeLocale")),select=view.querySelector(".displayModePremiere"),key="PlaybackTvModeRequiresEmbyPremiere",_servicelocator.appHost.supports("externallinks")&&_servicelocator.appHost.supports("externalpremium")?select.innerHTML=_globalize.default.translate(key,'<a is="emby-linkbutton" href="https://emby.media/premiere" data-preset="premiereinfo" target="_blank" class="button-link">',"</a>"):select.innerHTML=_globalize.default.translate(key,"",""),options.element.querySelector(".chkTVDisplayMode").addEventListener("change",function(e){var selectCardSize=(e=e.target.closest(".settingsContainer")).querySelector(".selectCardSize"),selectCardSize=(this.setFieldValue(selectCardSize,normalizeCardSize("normal"),!0),e.querySelector(".selectFontSize"));this.setFieldValue(selectCardSize,"",!0)}.bind(this)),options.element.querySelector("form").addEventListener("submit",function(e){return e.preventDefault(),!1}.bind(options))}function revertToNoneIfNeeded(elem,value){return value&&elem.querySelector('option[value="'+value+'"]')?value:"none"}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,Object.assign(View.prototype,_basesettingsview.default.prototype),View.prototype.loadSettingsInternal=function(){var instance=this;return fillStartupBehavior(instance.settingsOptions.element).then(function(){return instance.loadAutoSettings()})},View.prototype.getSettingValueFromOwner=function(owner,memberInfo){switch(memberInfo.member){case"soundEffects":return revertToNoneIfNeeded(this.view.querySelector(".selectSoundEffects"),_basesettingsview.default.prototype.getSettingValueFromOwner.apply(this,arguments));case"screensaver":return revertToNoneIfNeeded(this.view.querySelector(".selectScreensaver"),_basesettingsview.default.prototype.getSettingValueFromOwner.apply(this,arguments));case"cardSize":return normalizeCardSize(_basesettingsview.default.prototype.getSettingValueFromOwner.apply(this,arguments));default:return _basesettingsview.default.prototype.getSettingValueFromOwner.apply(this,arguments)}},View.prototype.destroy=function(){_basesettingsview.default.prototype.destroy.apply(this,arguments),this.settingsOptions=null};_exports.default=View});