/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.CucumberBackendException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MethodFormat {
    static final MethodFormat FULL = new MethodFormat("%qc.%m(%qa)");
    private static final Pattern METHOD_PATTERN = Pattern.compile("((?:static\\s|public\\s)+)([^\\s]*)\\s\\.?(.*)\\.([^\\(]*)\\(([^\\)]*)\\)(?: throws )?(.*)");
    private final MessageFormat format;

    private MethodFormat(String format) {
        String pattern = format.replaceAll("%qc", "{0}").replaceAll("%m", "{1}").replaceAll("%qa", "{2}");
        this.format = new MessageFormat(pattern);
    }

    String format(Method method) {
        String signature = method.toGenericString();
        Matcher matcher = METHOD_PATTERN.matcher(signature);
        if (matcher.find()) {
            String qc = matcher.group(3);
            String m = matcher.group(4);
            String qa = matcher.group(5);
            return this.format.format(new Object[]{qc, m, qa});
        }
        throw new CucumberBackendException("Cucumber bug: Couldn't format " + signature);
    }
}

