/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.PatternCompilerProvider;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

final class TreeRegexp {
    private final Pattern pattern;
    private final GroupBuilder groupBuilder;

    TreeRegexp(String regexp) {
        this(PatternCompilerProvider.getCompiler().compile(regexp, 256));
    }

    TreeRegexp(Pattern pattern) {
        this.pattern = pattern;
        this.groupBuilder = TreeRegexp.createGroupBuilder(pattern);
    }

    static GroupBuilder createGroupBuilder(Pattern pattern) {
        String source = pattern.pattern();
        ArrayDeque<GroupBuilder> stack = new ArrayDeque<GroupBuilder>(Collections.singleton(new GroupBuilder(0)));
        boolean escaping = false;
        boolean charClass = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '[' && !escaping) {
                charClass = true;
            } else if (c == ']' && !escaping) {
                charClass = false;
            } else if (c == '(' && !escaping && !charClass) {
                boolean nonCapturing = TreeRegexp.isNonCapturingGroup(source, i);
                GroupBuilder groupBuilder = new GroupBuilder(i);
                if (nonCapturing) {
                    groupBuilder.setNonCapturing();
                }
                stack.push(groupBuilder);
            } else if (c == ')' && !escaping && !charClass) {
                GroupBuilder gb = (GroupBuilder)stack.pop();
                if (gb.isCapturing()) {
                    gb.setSource(source.substring(gb.getStartIndex() + 1, i));
                    ((GroupBuilder)stack.peek()).add(gb);
                } else {
                    gb.moveChildrenTo((GroupBuilder)stack.peek());
                }
                gb.setEndIndex(i);
            }
            escaping = c == '\\' && !escaping;
        }
        return (GroupBuilder)stack.pop();
    }

    private static boolean isNonCapturingGroup(String source, int i) {
        if (source.charAt(i + 1) != '?') {
            return false;
        }
        if (source.charAt(i + 2) != '<') {
            return true;
        }
        return source.charAt(i + 3) == '=' || source.charAt(i + 3) == '!';
    }

    Pattern pattern() {
        return this.pattern;
    }

    Group match(CharSequence s) {
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        return this.groupBuilder.build(matcher, IntStream.rangeClosed(0, matcher.groupCount()).iterator());
    }

    public GroupBuilder getGroupBuilder() {
        return this.groupBuilder;
    }
}

