/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.backends.experimental.smt.ArrayConstant;
import firrtl.backends.experimental.smt.ArrayEqual;
import firrtl.backends.experimental.smt.ArrayExpr;
import firrtl.backends.experimental.smt.ArrayFunctionCall;
import firrtl.backends.experimental.smt.ArrayIte;
import firrtl.backends.experimental.smt.ArrayRead;
import firrtl.backends.experimental.smt.ArrayStore;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.BVAnd;
import firrtl.backends.experimental.smt.BVComparison;
import firrtl.backends.experimental.smt.BVConcat;
import firrtl.backends.experimental.smt.BVEqual;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVExtend;
import firrtl.backends.experimental.smt.BVForall;
import firrtl.backends.experimental.smt.BVFunctionCall;
import firrtl.backends.experimental.smt.BVImplies;
import firrtl.backends.experimental.smt.BVImplies$;
import firrtl.backends.experimental.smt.BVIte;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVNegate;
import firrtl.backends.experimental.smt.BVNot;
import firrtl.backends.experimental.smt.BVOp;
import firrtl.backends.experimental.smt.BVOr;
import firrtl.backends.experimental.smt.BVReduceAnd;
import firrtl.backends.experimental.smt.BVReduceOr;
import firrtl.backends.experimental.smt.BVReduceXor;
import firrtl.backends.experimental.smt.BVSlice;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.Compare$;
import firrtl.backends.experimental.smt.SMTFunctionArg;
import firrtl.backends.experimental.smt.UTSymbol;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.package$;

public final class SMTExprSerializer$ {
    public static final SMTExprSerializer$ MODULE$ = new SMTExprSerializer$();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String serialize(BVExpr expr2) {
        BVImplies bVImplies;
        Some<Tuple2<BVExpr, BVExpr>> some;
        boolean bl = false;
        BVExtend bVExtend = null;
        boolean bl2 = false;
        BVSlice bVSlice = null;
        boolean bl3 = false;
        BVComparison bVComparison = null;
        BVExpr bVExpr = expr2;
        if (bVExpr instanceof BVLiteral) {
            BVLiteral bVLiteral = (BVLiteral)bVExpr;
            return bVLiteral.width() <= 8 ? new StringBuilder(2).append(Integer.toString(bVLiteral.width())).append("'b").append(bVLiteral.value().toString(2)).toString() : new StringBuilder(2).append(Integer.toString(bVLiteral.width())).append("'x").append(bVLiteral.value().toString(16)).toString();
        }
        if (bVExpr instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)bVExpr;
            String name = bVSymbol.name();
            return name;
        }
        if (bVExpr instanceof BVExtend) {
            bl = true;
            bVExtend = (BVExtend)bVExpr;
            BVExpr e = bVExtend.e();
            int by = bVExtend.by();
            boolean bl4 = bVExtend.signed();
            if (!bl4) {
                return new StringBuilder(8).append("zext(").append(this.serialize(e)).append(", ").append(by).append(")").toString();
            }
        }
        if (bl) {
            BVExpr e = bVExtend.e();
            int by = bVExtend.by();
            boolean bl5 = bVExtend.signed();
            if (bl5) {
                return new StringBuilder(8).append("sext(").append(this.serialize(e)).append(", ").append(by).append(")").toString();
            }
        }
        if (bVExpr instanceof BVSlice) {
            int lo;
            bl2 = true;
            bVSlice = (BVSlice)bVExpr;
            BVExpr e = bVSlice.e();
            int hi = bVSlice.hi();
            if (hi == (lo = bVSlice.lo())) {
                return new StringBuilder(2).append(this.serialize(e)).append("[").append(hi).append("]").toString();
            }
        }
        if (bl2) {
            BVExpr e = bVSlice.e();
            int hi = bVSlice.hi();
            int lo = bVSlice.lo();
            return new StringBuilder(3).append(this.serialize(e)).append("[").append(hi).append(":").append(lo).append("]").toString();
        }
        if (bVExpr instanceof BVNot) {
            BVNot bVNot = (BVNot)bVExpr;
            BVExpr e = bVNot.e();
            return new StringBuilder(5).append("not(").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVNegate) {
            BVNegate bVNegate = (BVNegate)bVExpr;
            BVExpr e = bVNegate.e();
            return new StringBuilder(5).append("neg(").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVForall) {
            BVForall bVForall = (BVForall)bVExpr;
            BVSymbol variable = bVForall.variable();
            BVExpr e = bVForall.e();
            return new StringBuilder(16).append("forall(").append(variable.name()).append(" : bv<").append(variable.width()).append(", ").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVReduceAnd) {
            BVReduceAnd bVReduceAnd = (BVReduceAnd)bVExpr;
            BVExpr e = bVReduceAnd.e();
            return new StringBuilder(8).append("redand(").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVReduceOr) {
            BVReduceOr bVReduceOr = (BVReduceOr)bVExpr;
            BVExpr e = bVReduceOr.e();
            return new StringBuilder(7).append("redor(").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVReduceXor) {
            BVReduceXor bVReduceXor = (BVReduceXor)bVExpr;
            BVExpr e = bVReduceXor.e();
            return new StringBuilder(8).append("redxor(").append(this.serialize(e)).append(")").toString();
        }
        if (bVExpr instanceof BVEqual) {
            BVEqual bVEqual = (BVEqual)bVExpr;
            BVExpr a = bVEqual.a();
            BVExpr b = bVEqual.b();
            return new StringBuilder(6).append("eq(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVComparison) {
            bl3 = true;
            bVComparison = (BVComparison)bVExpr;
            Enumeration.Value value = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl6 = bVComparison.signed();
            Enumeration.Value value2 = Compare$.MODULE$.Greater();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null) && !bl6) {
                return new StringBuilder(7).append("ugt(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
            }
        }
        if (bl3) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl7 = bVComparison.signed();
            Enumeration.Value value4 = Compare$.MODULE$.Greater();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null) && bl7) {
                return new StringBuilder(7).append("sgt(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
            }
        }
        if (bl3) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl8 = bVComparison.signed();
            Enumeration.Value value6 = Compare$.MODULE$.GreaterEqual();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null) && !bl8) {
                return new StringBuilder(8).append("ugeq(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
            }
        }
        if (bl3) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl9 = bVComparison.signed();
            Enumeration.Value value8 = Compare$.MODULE$.GreaterEqual();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null) && bl9) {
                return new StringBuilder(8).append("sgeq(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
            }
        }
        if (bVExpr instanceof BVOp) {
            BVOp bVOp = (BVOp)bVExpr;
            Enumeration.Value op = bVOp.op();
            BVExpr a = bVOp.a();
            BVExpr b = bVOp.b();
            return new StringBuilder(4).append(op).append("(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVConcat) {
            BVConcat bVConcat = (BVConcat)bVExpr;
            BVExpr a = bVConcat.a();
            BVExpr b = bVConcat.b();
            return new StringBuilder(10).append("concat(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof ArrayRead) {
            ArrayRead arrayRead = (ArrayRead)bVExpr;
            ArrayExpr array = arrayRead.array();
            BVExpr index = arrayRead.index();
            return new StringBuilder(2).append(this.serialize(array)).append("[").append(this.serialize(index)).append("]").toString();
        }
        if (bVExpr instanceof ArrayEqual) {
            ArrayEqual arrayEqual = (ArrayEqual)bVExpr;
            ArrayExpr a = arrayEqual.a();
            ArrayExpr b = arrayEqual.b();
            return new StringBuilder(6).append("eq(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVImplies && !(some = BVImplies$.MODULE$.unapply(bVImplies = (BVImplies)bVExpr)).isEmpty()) {
            BVExpr a = some.get()._1();
            BVExpr b = some.get()._2();
            return new StringBuilder(11).append("implies(").append(this.serialize(a)).append(", ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVIte) {
            BVIte bVIte = (BVIte)bVExpr;
            BVExpr cond = bVIte.cond();
            BVExpr tru = bVIte.tru();
            BVExpr fals = bVIte.fals();
            return new StringBuilder(9).append("ite(").append(this.serialize(cond)).append(", ").append(this.serialize(tru)).append(", ").append(this.serialize(fals)).append(")").toString();
        }
        if (bVExpr instanceof BVFunctionCall) {
            BVFunctionCall bVFunctionCall = (BVFunctionCall)bVExpr;
            String name = bVFunctionCall.name();
            List<SMTFunctionArg> args = bVFunctionCall.args();
            return new StringBuilder(0).append(name).append(this.serialize(args).mkString("(", ",", ")")).toString();
        }
        if (bVExpr instanceof BVAnd) {
            BVAnd bVAnd = (BVAnd)bVExpr;
            List<BVExpr> terms = bVAnd.terms();
            return ((AbstractIterable)terms.map((Function1<BVExpr, String> & Serializable)expr -> MODULE$.serialize((BVExpr)expr))).mkString("and(", ", ", ")");
        }
        if (!(bVExpr instanceof BVOr)) throw new MatchError(bVExpr);
        BVOr bVOr = (BVOr)bVExpr;
        List<BVExpr> terms = bVOr.terms();
        return ((AbstractIterable)terms.map((Function1<BVExpr, String> & Serializable)expr -> MODULE$.serialize((BVExpr)expr))).mkString("or(", ", ", ")");
    }

    public String serialize(ArrayExpr expr) {
        String string;
        ArrayExpr arrayExpr = expr;
        if (arrayExpr instanceof ArraySymbol) {
            String name;
            ArraySymbol arraySymbol = (ArraySymbol)arrayExpr;
            string = name = arraySymbol.name();
        } else if (arrayExpr instanceof ArrayConstant) {
            ArrayConstant arrayConstant = (ArrayConstant)arrayExpr;
            BVExpr e = arrayConstant.e();
            int indexWidth = arrayConstant.indexWidth();
            string = new StringBuilder(7).append("([").append(this.serialize(e)).append("] x ").append(package$.MODULE$.BigInt().apply(1).$less$less(indexWidth)).append(")").toString();
        } else if (arrayExpr instanceof ArrayStore) {
            ArrayStore arrayStore = (ArrayStore)arrayExpr;
            ArrayExpr array = arrayStore.array();
            BVExpr index = arrayStore.index();
            BVExpr data2 = arrayStore.data();
            string = new StringBuilder(6).append(this.serialize(array)).append("[").append(this.serialize(index)).append(" := ").append(this.serialize(data2)).append("]").toString();
        } else if (arrayExpr instanceof ArrayIte) {
            ArrayIte arrayIte = (ArrayIte)arrayExpr;
            BVExpr cond = arrayIte.cond();
            ArrayExpr tru = arrayIte.tru();
            ArrayExpr fals = arrayIte.fals();
            string = new StringBuilder(9).append("ite(").append(this.serialize(cond)).append(", ").append(this.serialize(tru)).append(", ").append(this.serialize(fals)).append(")").toString();
        } else if (arrayExpr instanceof ArrayFunctionCall) {
            ArrayFunctionCall arrayFunctionCall = (ArrayFunctionCall)arrayExpr;
            String name = arrayFunctionCall.name();
            List<SMTFunctionArg> args = arrayFunctionCall.args();
            string = new StringBuilder(0).append(name).append(this.serialize(args).mkString("(", ",", ")")).toString();
        } else {
            throw new MatchError(arrayExpr);
        }
        return string;
    }

    private Iterable<String> serialize(Iterable<SMTFunctionArg> args) {
        return (Iterable)args.map((Function1<SMTFunctionArg, String> & Serializable)x0$1 -> {
            String string;
            SMTFunctionArg sMTFunctionArg = x0$1;
            if (sMTFunctionArg instanceof BVExpr) {
                BVExpr bVExpr = (BVExpr)sMTFunctionArg;
                string = MODULE$.serialize(bVExpr);
            } else if (sMTFunctionArg instanceof ArrayExpr) {
                ArrayExpr arrayExpr = (ArrayExpr)sMTFunctionArg;
                string = MODULE$.serialize(arrayExpr);
            } else if (sMTFunctionArg instanceof UTSymbol) {
                UTSymbol uTSymbol = (UTSymbol)sMTFunctionArg;
                string = uTSymbol.name();
            } else {
                throw new MatchError(sMTFunctionArg);
            }
            return string;
        });
    }

    private SMTExprSerializer$() {
    }
}

