/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;

public final class DummyConnection
extends Connection {
    private static final Logger logger = Logger.getLogger(DummyConnection.class.getName());
    private DummyConnection otherConnection;

    public DummyConnection(String name) {
        super(name);
    }

    public DummyConnection getOtherConnection() {
        return this.otherConnection;
    }

    public void setOtherConnection(DummyConnection dc) {
        this.otherConnection = dc;
    }

    @Override
    public boolean isAlive() {
        return this.otherConnection != null;
    }

    @Override
    public void close() {
        this.otherConnection = null;
    }

    @Override
    public void sendMessage(Message message) throws FreeColException, IOException {
        Message reply = this.askMessage(message, 30000L);
        assert (reply == null);
    }

    @Override
    public Message askMessage(Message message, long timeout) throws FreeColException, IOException {
        DummyConnection other = this.getOtherConnection();
        if (other == null) {
            return null;
        }
        if (message == null) {
            return null;
        }
        this.logMessage(message, true);
        Message reply = other.handle(message);
        this.logMessage(reply, false);
        return reply;
    }

    @Override
    public String toString() {
        return "[DummyConnection " + this.getName() + "]";
    }
}

