/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.help;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.help.AboutAction;
import org.freeplane.features.help.DocumentationAction;
import org.freeplane.features.help.FilePropertiesAction;
import org.freeplane.features.help.HotKeyInfoAction;
import org.freeplane.features.help.OpenURLAction;
import org.freeplane.features.mode.Controller;

public class HelpController
implements IExtension {
    public static HelpController getController() {
        return Controller.getCurrentController().getExtension(HelpController.class);
    }

    public static void install() {
        Controller controller = Controller.getCurrentController();
        controller.addExtension(HelpController.class, new HelpController());
    }

    public HelpController() {
        Controller controller = Controller.getCurrentController();
        ResourceController resourceController = ResourceController.getResourceController();
        controller.addAction(new AboutAction());
        controller.addAction(new OpenURLAction("OpenFreeplaneSiteAction", resourceController.getProperty("webFreeplaneLocation")));
        if (resourceController.isApplet()) {
            return;
        }
        controller.addAction(new FilePropertiesAction());
        controller.addAction(new OpenURLAction("ReportBugAction", resourceController.getProperty("bugTrackerLocation")));
        controller.addAction(new OpenURLAction("RequestFeatureAction", resourceController.getProperty("featureTrackerLocation")));
        controller.addAction(new OpenURLAction("AskForHelp", resourceController.getProperty("helpForumLocation")));
        controller.addAction(new OpenURLAction("FreeplaneHandbook", resourceController.getProperty("handbook_url")));
        String defaultMap = resourceController.getProperty("docu_map");
        controller.addAction(new DocumentationAction("DocumentationAction", defaultMap));
        String tutorialMap = resourceController.getProperty("tutorial_map");
        controller.addAction(new DocumentationAction("TutorialAction", tutorialMap));
        String latestFeaturesMap = resourceController.getProperty("latest_features_map");
        controller.addAction(new DocumentationAction("LatestFeaturesAction", latestFeaturesMap));
        controller.addAction(new HotKeyInfoAction());
    }
}

