/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeView;

@EnabledAction(checkOnNodeChange=true)
public class EditAttributesAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public EditAttributesAction() {
        super("EditAttributesAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean attributesClosed;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        NodeView nodeView = this.getSelectedNode();
        AttributeView attributeView = nodeView.getAttributeView();
        boolean bl = attributesClosed = null == SwingUtilities.getAncestorOfClass(AttributeTable.class, focusOwner);
        if (attributesClosed) {
            attributeView.startEditing();
        } else {
            attributeView.stopEditing();
        }
    }

    private NodeView getSelectedNode() {
        Controller controller = Controller.getCurrentController();
        NodeView nodeView = ((MapView)controller.getMapViewManager().getMapViewComponent()).getSelected();
        return nodeView;
    }

    @Override
    public void setEnabled() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        this.setEnabled(selection != null && !TextController.getController().isMinimized(selection.getSelected(), this.getSelectedNode()));
    }
}

