# This file is generated by coder.py. DO NOT EDIT!
# ruff: noqa: F401, E402, F811
# fmt: off

from __future__ import annotations

from gaphor.core.modeling.properties import (
    association,
    attribute as _attribute,
    derived,
    derivedunion,
    enumeration as _enumeration,
    redefine,
    relation_many,
    relation_one,
)


from typing import Callable

from gaphor.core.modeling import UnlimitedNatural


from gaphor.core.modeling.base import Base
class Element(Base):
    appliedStereotype: relation_many[InstanceSpecification]
    comment: relation_many[Comment]
    note: _attribute[str] = _attribute("note", str)
    ownedDiagram: relation_many[Diagram]
    ownedElement: relation_many[Element]
    owner: relation_one[Element]
    relationship: relation_many[Relationship]


class NamedElement(Element):
    clientDependency: relation_many[Dependency]
    memberNamespace: relation_one[Namespace]
    name: _attribute[str] = _attribute("name", str)
    nameExpression: _attribute[str] = _attribute("nameExpression", str)
    namespace: relation_one[Namespace]
    qualifiedName: property
    supplierDependency: relation_many[Dependency]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class PackageableElement(NamedElement):
    component: relation_one[Component]
    owningPackage: relation_one[Package]


class DeployedArtifact(NamedElement):
    deployment: relation_many[Deployment]


class DeploymentTarget(NamedElement):
    deployment: relation_many[Deployment]


class InstanceSpecification(DeployedArtifact, DeploymentTarget, PackageableElement):
    classifier: relation_many[Classifier]
    extended: relation_many[Element]
    slot: relation_many[Slot]
    specification: relation_one[ValueSpecification]


class EnumerationLiteral(InstanceSpecification):
    enumeration: relation_one[Enumeration]


class Relationship(Element):
    abstraction: relation_many[InformationFlow]
    relatedElement: relation_many[Element]


class DirectedRelationship(Relationship):
    source: relation_many[Element]
    target: relation_many[Element]


class PackageMerge(DirectedRelationship):
    mergedPackage: relation_one[Package]
    mergingPackage: relation_one[Package]


class RedefinableElement(NamedElement):
    isLeaf: _attribute[bool] = _attribute("isLeaf", bool, default=True)
    redefinedElement: relation_many[RedefinableElement]
    redefinitionContext: relation_many[Classifier]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class Namespace(NamedElement):
    elementImport: relation_many[ElementImport]
    importedMember: derivedunion[PackageableElement]
    member: relation_many[NamedElement]
    ownedMember: relation_many[NamedElement]
    ownedRule: relation_many[Constraint]
    packageImport: relation_many[PackageImport]


class Type(PackageableElement):
    package: relation_one[Package]


class Classifier(Namespace, RedefinableElement, Type):
    attribute: relation_many[Property]
    componentRealization: relation_many[ComponentRealization]
    feature: relation_many[Feature]
    general: derived[Classifier]
    generalization: relation_many[Generalization]
    inheritedMember: derivedunion[NamedElement]
    instanceSpecification: relation_many[InstanceSpecification]
    isAbstract: _attribute[bool] = _attribute("isAbstract", bool, default=False)
    isFinalSpecialization: _attribute[bool] = _attribute("isFinalSpecialization", bool, default=False)
    nestingClass: relation_one[Class]
    ownedUseCase: relation_many[UseCase]
    redefinedClassifier: relation_many[Classifier]
    specialization: relation_many[Generalization]
    useCase: relation_many[UseCase]


class Association(Classifier, Relationship):
    endType: derived[Type]
    isDerived: _attribute[bool] = _attribute("isDerived", bool, default=False)
    memberEnd: relation_many[Property]
    navigableOwnedEnd: relation_many[Property]
    ownedEnd: relation_many[Property]


class Extension(Association):
    isRequired: _attribute[bool] = _attribute("isRequired", bool)
    metaclass: property
    ownedEnd: relation_one[ExtensionEnd]  # type: ignore[assignment]


class BehavioredClassifier(Classifier):
    behavior: relation_many[Behavior]
    classifierBehavior: relation_one[Behavior]
    interfaceRealization: relation_many[InterfaceRealization]
    ownedBehavior: relation_many[Behavior]


class Actor(BehavioredClassifier):
    pass


class ActivityNode(RedefinableElement):
    activity: relation_one[Activity]
    inGroup: relation_many[ActivityGroup]
    inPartition: relation_many[ActivityPartition]
    incoming: relation_many[ActivityEdge]
    outgoing: relation_many[ActivityEdge]
    redefinedElement: relation_many[ActivityNode]  # type: ignore[assignment]


class ControlNode(ActivityNode):
    pass


class MergeNode(ControlNode):
    pass


class Feature(RedefinableElement):
    featuringClassifier: relation_many[Classifier]
    isStatic: _attribute[bool] = _attribute("isStatic", bool, default=False)


class ActivityEdge(RedefinableElement):
    activity: relation_one[Activity]
    guard: relation_one[ValueSpecification]
    inGroup: relation_many[ActivityGroup]
    redefinedElement: relation_many[ActivityEdge]  # type: ignore[assignment]
    source: relation_one[ActivityNode]
    target: relation_one[ActivityNode]
    weight: relation_one[ValueSpecification]


class ObjectFlow(ActivityEdge):
    pass


class TypedElement(PackageableElement):
    type: relation_one[Type]
    typeValue: _attribute[str] = _attribute("typeValue", str)


class ValueSpecification(TypedElement):
    activityEdge: relation_one[ActivityEdge]
    changeEvent: relation_one[ChangeEvent]
    joinNode: relation_one[JoinNode]
    lifeline: relation_one[Lifeline]
    objectNode: relation_one[ObjectNode]
    owningConstraint: relation_one[Constraint]
    owningLower: relation_one[MultiplicityElement]
    owningParameter: relation_one[Parameter]
    owningProperty: relation_one[Property]
    owningSlot: relation_one[Slot]
    owningUpper: relation_one[MultiplicityElement]
    valueSpecificationAction: relation_one[ValueSpecificationAction]


class LiteralSpecification(ValueSpecification):
    value: _attribute[str] = _attribute("value", str)


class FinalNode(ControlNode):
    pass


class ActivityFinalNode(FinalNode):
    pass


class CommunicationPath(Association):
    pass


class Dependency(DirectedRelationship, PackageableElement):
    client: relation_many[NamedElement]
    supplier: relation_many[NamedElement]


class Abstraction(Dependency):
    mapping: _attribute[str] = _attribute("mapping", str)


class Realization(Abstraction):
    pass


class ObjectNode(ActivityNode, TypedElement):
    isControlType: _attribute[bool] = _attribute("isControlType", bool, default=False)
    ordering = _enumeration("ordering", ("unordered", "ordered", "LIFO", "FIFO"), "unordered")
    selection: relation_one[Behavior]
    upperBound: relation_one[ValueSpecification]


class MultiplicityElement(Element):
    isOrdered: _attribute[bool] = _attribute("isOrdered", bool, default=False)
    isUnique: _attribute[bool] = _attribute("isUnique", bool, default=True)
    lowerValue: relation_one[ValueSpecification]
    upperValue: relation_one[ValueSpecification]


class Pin(MultiplicityElement, ObjectNode):
    isControl: _attribute[bool] = _attribute("isControl", bool, default=False)


class Generalization(DirectedRelationship):
    general: relation_one[Classifier]
    isSubstitutable: _attribute[bool] = _attribute("isSubstitutable", bool)
    specific: relation_one[Classifier]


class StructuredClassifier(Classifier):
    ownedAttribute: relation_many[Property]
    ownedConnector: relation_many[Connector]
    part: property
    role: relation_many[ConnectableElement]


class EncapsulatedClassifier(StructuredClassifier):
    ownedPort: relation_many[Port]


class Class(BehavioredClassifier, EncapsulatedClassifier):
    extension: property
    isActive: _attribute[bool] = _attribute("isActive", bool, default=False)
    nestedClassifier: relation_many[Classifier]
    ownedAttribute: relation_many[Property]  # type: ignore[assignment]
    ownedOperation: relation_many[Operation]
    superClass: derived[Classifier]


class Node(Class, DeploymentTarget):
    nestedNode: relation_many[Node]
    node: relation_one[Node]


class Device(Node):
    pass


class StructuralFeature(Feature, MultiplicityElement, TypedElement):
    isReadOnly: _attribute[bool] = _attribute("isReadOnly", bool, default=False)
    slot: relation_many[Slot]


class UseCase(BehavioredClassifier):
    extend: relation_many[Extend]
    extensionPoint: relation_many[ExtensionPoint]
    include: relation_many[Include]
    subject: relation_many[Classifier]


class LiteralNull(LiteralSpecification):
    pass


class InputPin(Pin):
    opaqueAction: relation_one[Action]


class Manifestation(Abstraction):
    artifact: relation_one[Artifact]


class Component(Class):
    isIndirectlyInstantiated: _attribute[bool] = _attribute("isIndirectlyInstantiated", bool, default=True)
    packagedElement: relation_many[PackageableElement]
    provided: property
    realization: relation_many[ComponentRealization]
    required: property


class ConnectableElement(TypedElement):
    end: relation_many[ConnectorEnd]
    lifeline: relation_many[Lifeline]


class Interface(Classifier, ConnectableElement):
    interfaceRealization: relation_many[InterfaceRealization]
    nestedClassifier: relation_many[Classifier]
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]
    redefinedInterface: relation_many[Interface]


class Include(DirectedRelationship, NamedElement):
    addition: relation_one[UseCase]
    includingCase: relation_one[UseCase]


class LiteralInteger(LiteralSpecification):
    value: _attribute[int] = _attribute("value", int)


class ProfileApplication(DirectedRelationship):
    appliedProfile: relation_one[Profile]


class ExtensionPoint(RedefinableElement):
    useCase: relation_one[UseCase]


class Usage(Dependency):
    pass


class ElementImport(DirectedRelationship):
    alias: _attribute[str] = _attribute("alias", str)
    importedElement: relation_one[PackageableElement]
    importingNamespace: relation_one[Namespace]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class Property(ConnectableElement, StructuralFeature):
    aggregation = _enumeration("aggregation", ("none", "shared", "composite"), "none")
    artifact: relation_one[Artifact]
    association: relation_one[Association]
    association2: relation_one[Association]
    class_: relation_one[Class]
    classifier: relation_one[Classifier]
    datatype: relation_one[DataType]
    defaultValue: relation_one[ValueSpecification]
    interface_: relation_one[Interface]
    isComposite: derived[bool]
    isDerived: _attribute[bool] = _attribute("isDerived", bool, default=False)
    isDerivedUnion: _attribute[bool] = _attribute("isDerivedUnion", bool, default=False)
    isID: _attribute[bool] = _attribute("isID", bool, default=False)
    isReadOnly: _attribute[bool] = _attribute("isReadOnly", bool, default=False)
    navigability: derived[bool | None]
    opposite: relation_one[Property]
    owningAssociation: relation_one[Association]
    redefinedProperty: relation_many[Property]
    structuredClassifier: relation_one[StructuredClassifier]
    subsettedProperty: relation_many[Property]


class ExtensionEnd(Property):
    type: relation_one[Stereotype]  # type: ignore[assignment]


class DataType(Classifier):
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class Enumeration(DataType):
    ownedLiteral: relation_many[EnumerationLiteral]


class Slot(Element):
    definingFeature: relation_one[StructuralFeature]
    owningInstance: relation_one[InstanceSpecification]
    value: relation_one[ValueSpecification]


class ExecutableNode(ActivityNode):
    pass


class InitialNode(ControlNode):
    pass


class Stereotype(Class):
    icon: relation_many[Image]
    profile: relation_one[Profile]


class Artifact(Classifier, DeployedArtifact):
    artifact: relation_one[Artifact]
    manifestation: relation_many[Manifestation]
    nestedArtifact: relation_many[Artifact]
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class LiteralUnlimitedNatural(LiteralSpecification):
    value: _attribute[UnlimitedNatural] = _attribute("value", UnlimitedNatural)


class ActivityParameterNode(ObjectNode):
    parameter: relation_one[Parameter]


class PrimitiveType(DataType):
    pass


class DecisionNode(ControlNode):
    decisionInput: relation_one[Behavior]


class Package(Namespace, PackageableElement):
    appliedProfile: relation_many[ProfileApplication]
    nestedPackage: relation_many[Package]
    nestingPackage: relation_one[Package]
    ownedType: relation_many[Type]
    packageMerge: relation_many[PackageMerge]
    packagedElement: relation_many[PackageableElement]


class Profile(Package):
    metaclassReference: relation_many[ElementImport]
    metamodelReference: relation_many[PackageImport]


class Behavior(Class):
    action_transition: relation_one[Transition]
    behavioredClassifier: relation_one[BehavioredClassifier]
    behavioredClassifier_: relation_one[BehavioredClassifier]
    context: relation_one[BehavioredClassifier]
    isReentrant: _attribute[bool] = _attribute("isReentrant", bool)
    ownedParameter: relation_many[Parameter]
    ownedParameterSet: relation_many[ParameterSet]
    redefinedBehavior: relation_many[Behavior]
    trigger_transition: relation_one[Transition]


class Activity(Behavior):
    body: _attribute[str] = _attribute("body", str)
    edge: relation_many[ActivityEdge]
    group: relation_many[ActivityGroup]
    language: _attribute[str] = _attribute("language", str)
    node: relation_many[ActivityNode]


class LiteralBoolean(LiteralSpecification):
    value: _attribute[bool] = _attribute("value", bool)


class InterfaceRealization(Realization):
    contract: relation_one[Interface]
    implementingClassifier: relation_one[BehavioredClassifier]


class Parameter(ConnectableElement, MultiplicityElement):
    activityParameterNode: relation_many[ActivityParameterNode]
    behavior: relation_one[Behavior]
    defaultValue: relation_one[ValueSpecification]
    direction = _enumeration("direction", ("inout", "in", "out", "return"), "inout")
    operation: relation_one[Operation]
    ownerFormalParam: relation_one[BehavioralFeature]
    parameterSet: relation_many[ParameterSet]


class BehavioralFeature(Feature, Namespace):
    isAbstract: _attribute[bool] = _attribute("isAbstract", bool)
    method: relation_many[Behavior]
    ownedParameter: relation_many[Parameter]
    ownedParameterSet: relation_one[ParameterSet]
    raisedException: relation_many[Type]


class Operation(BehavioralFeature):
    artifact: relation_one[Artifact]
    bodyCondition: relation_one[Constraint]
    class_: relation_one[Class]
    datatype: relation_one[DataType]
    interface_: relation_one[Interface]
    isQuery: _attribute[bool] = _attribute("isQuery", bool, default=False)
    ownedParameter: relation_many[Parameter]  # type: ignore[assignment]
    postcondition: relation_many[Constraint]
    precondition: relation_many[Constraint]
    raisedException: relation_many[Type]  # type: ignore[assignment]
    redefinedOperation: relation_many[Operation]
    type: derivedunion[DataType]


class ControlFlow(ActivityEdge):
    pass


class LiteralString(LiteralSpecification):
    value: _attribute[str] = _attribute("value", str)


class OutputPin(Pin):
    opaqueAction: relation_one[Action]


class ValuePin(InputPin):
    value_: relation_one[ValueSpecification]


class Action(ExecutableNode):
    body: _attribute[str] = _attribute("body", str)
    context_: relation_one[Classifier]
    effect: _attribute[str] = _attribute("effect", str)
    inputValue: relation_many[InputPin]
    interaction: relation_one[Interaction]
    outputValue: relation_many[OutputPin]


class ExecutionEnvironment(Node):
    pass


class Extend(DirectedRelationship, NamedElement):
    constraint: relation_one[Constraint]
    extendedCase: relation_one[UseCase]
    extension: relation_one[UseCase]
    extensionLocation: relation_many[ExtensionPoint]


class ActivityGroup(NamedElement):
    activity: relation_one[Activity]
    edgeContents: relation_many[ActivityEdge]
    nodeContents: relation_many[ActivityNode]
    subgroup: relation_many[ActivityGroup]
    superGroup: relation_one[ActivityGroup]


class Constraint(PackageableElement):
    constrainedElement: relation_many[Element]
    context: relation_one[Namespace]
    owningState: relation_one[State]
    parameterSet: relation_one[ParameterSet]
    specification: relation_one[ValueSpecification]
    stateInvariant: relation_one[StateInvariant]
    transition: relation_one[Transition]


class PackageImport(DirectedRelationship):
    importedPackage: relation_one[Package]
    importingNamespace: relation_one[Namespace]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class InteractionFragment(NamedElement):
    covered: relation_one[Lifeline]
    enclosingInteraction: relation_one[Interaction]
    generalOrdering: relation_many[GeneralOrdering]


class Interaction(Behavior, InteractionFragment):
    action: relation_many[Action]
    fragment: relation_many[InteractionFragment]
    lifeline: relation_many[Lifeline]
    message: relation_many[Message]


class StateInvariant(InteractionFragment):
    covered: relation_one[Lifeline]  # type: ignore[assignment]
    invariant: relation_one[Constraint]


class Lifeline(NamedElement):
    coveredBy: relation_many[InteractionFragment]
    interaction: relation_one[Interaction]
    represents: relation_one[ConnectableElement]
    selector: relation_one[ValueSpecification]
    parse: Callable[[Lifeline, str], None]
    render: Callable[[Lifeline], str]


class Message(NamedElement):
    argument: relation_one[ValueSpecification]
    interaction: relation_one[Interaction]
    messageEnd: relation_many[MessageEnd]
    messageKind: property
    messageSort = _enumeration("messageSort", ("synchCall", "asynchCall", "asynchSignal", "createMessage", "deleteMessage", "reply"), "synchCall")
    receiveEvent: relation_one[MessageEnd]
    sendEvent: relation_one[MessageEnd]
    signature: relation_one[NamedElement]


class MessageEnd(NamedElement):
    message: relation_one[Message]
    receiveMessage: relation_one[Message]
    sendMessage: relation_one[Message]


class OccurrenceSpecification(InteractionFragment):
    covered: relation_one[Lifeline]  # type: ignore[assignment]


class GeneralOrdering(NamedElement):
    interactionFragment: relation_one[InteractionFragment]


class Connector(Feature):
    contract: relation_many[Behavior]
    end: relation_many[ConnectorEnd]
    informationFlow: relation_many[InformationFlow]
    kind = _enumeration("kind", ("assembly", "delegation"), "assembly")
    redefinedConnector: relation_many[Connector]
    structuredClassifier: relation_one[StructuredClassifier]
    type: relation_one[Association]


class ConnectorEnd(MultiplicityElement):
    definingEnd: relation_one[Property]
    partWithPort: relation_one[Property]
    role: relation_one[ConnectableElement]


class FlowFinalNode(FinalNode):
    pass


class JoinNode(ControlNode):
    isCombineDuplicate: _attribute[bool] = _attribute("isCombineDuplicate", bool, default=True)
    joinSpec: relation_one[ValueSpecification]


class ForkNode(ControlNode):
    pass


class StateMachine(Behavior):
    region: relation_many[Region]


class Region(Namespace):
    state: relation_one[State]
    stateMachine: relation_one[StateMachine]
    subvertex: relation_many[Vertex]


class Transition(Namespace):
    action: relation_one[Behavior]
    container: relation_one[Region]
    effect: relation_one[Behavior]
    guard: relation_one[Constraint]
    kind = _enumeration("kind", ("internal", "local", "external"), "internal")
    source: relation_one[Vertex]
    target: relation_one[Vertex]
    trigger: relation_one[Behavior]


class Vertex(NamedElement):
    container: relation_one[Region]
    incoming: relation_many[Transition]
    outgoing: relation_many[Transition]


class Pseudostate(Vertex):
    kind = _enumeration("kind", ("initial", "deepHistory", "shallowHistory", "join", "fork", "junction", "choice", "entryPoint", "exitPoint", "terminate"), "initial")
    state: relation_one[State]
    stateMachine: relation_one[StateMachine]


class ConnectionPointReference(Vertex):
    entry: relation_many[Pseudostate]
    exit: relation_many[Pseudostate]
    state: relation_one[State]


class State(Namespace, Vertex):
    doActivity: relation_one[Behavior]
    entry: relation_one[Behavior]
    exit: relation_one[Behavior]
    region: relation_many[Region]
    statevariant: relation_one[Constraint]
    submachine: relation_one[StateMachine]


class FinalState(State):
    pass


class Port(Property):
    encapsulatedClassifier: relation_one[EncapsulatedClassifier]
    isBehavior: _attribute[bool] = _attribute("isBehavior", bool)
    isService: _attribute[bool] = _attribute("isService", bool)


class Deployment(Dependency):
    deployedArtifact: relation_many[DeployedArtifact]
    location: relation_one[DeploymentTarget]


class ActivityPartition(ActivityGroup):
    isDimension: _attribute[bool] = _attribute("isDimension", bool, default=False)
    isExternal: _attribute[bool] = _attribute("isExternal", bool, default=False)
    node: relation_many[ActivityNode]
    represents: relation_one[Element]
    subpartition: relation_many[ActivityPartition]


class MessageOccurrenceSpecification(MessageEnd, OccurrenceSpecification):
    pass


class AcceptEventAction(Action):
    isUnmarshall: _attribute[bool] = _attribute("isUnmarshall", bool, default=False)
    result: relation_many[OutputPin]


class ReplyAction(Action):
    replyValue: relation_one[InputPin]
    returnInformation: relation_one[InputPin]


class UnmarshallAction(Action):
    object: relation_one[InputPin]
    result: relation_many[OutputPin]
    unmarshallType: relation_one[Classifier]


class AcceptCallAction(AcceptEventAction):
    returnInformation: relation_one[OutputPin]


class InvocationAction(Action):
    argument: relation_many[InputPin]


class SendSignalAction(InvocationAction):
    target: relation_many[InputPin]


class Collaboration(BehavioredClassifier, StructuredClassifier):
    collaborationRole: relation_many[ConnectableElement]


class Trigger(NamedElement):
    event: relation_one[Event]
    port: relation_many[Port]


class Event(PackageableElement):
    pass


class ExecutionSpecification(InteractionFragment):
    executionOccurrenceSpecification: relation_many[ExecutionOccurrenceSpecification]
    finish: relation_one[ExecutionOccurrenceSpecification]
    start: relation_one[ExecutionOccurrenceSpecification]


class ExecutionOccurrenceSpecification(OccurrenceSpecification):
    execution: relation_one[ExecutionSpecification]


class ActionExecutionSpecification(ExecutionSpecification):
    action: relation_one[Action]


class BehaviorExecutionSpecification(ExecutionSpecification):
    behavior: relation_one[Behavior]


class ChangeEvent(Event):
    changeExpression: relation_one[ValueSpecification]


class StructuralFeatureAction(Action):
    pass


class WriteStructuralFeatureAction(StructuralFeatureAction):
    pass


class AddStructuralFeatureValueAction(WriteStructuralFeatureAction):
    isReplaceAll: _attribute[bool] = _attribute("isReplaceAll", bool, default=False)


class ParameterSet(NamedElement):
    behavior: relation_one[Behavior]
    behavioralFeature: relation_one[BehavioralFeature]
    condition: relation_many[Constraint]
    parameter: relation_many[Parameter]


class Image(Element):
    content: _attribute[str] = _attribute("content", str)
    format: _attribute[str] = _attribute("format", str)
    name: _attribute[str] = _attribute("name", str)


class ComponentRealization(Realization):
    abstraction: relation_one[Component]  # type: ignore[assignment]
    realizingClassifier: relation_one[Classifier]


class InformationItem(Classifier):
    represented: relation_many[Classifier]


class InformationFlow(DirectedRelationship, PackageableElement):
    conveyed: relation_many[Classifier]
    informationSource: relation_one[NamedElement]
    informationTarget: relation_one[NamedElement]
    realization: relation_many[Relationship]
    realizingActivityEdge: relation_many[ActivityEdge]
    realizingConnector: relation_one[Connector]
    realizingMessage: relation_many[Message]


class OpaqueAction(Action):
    body: _attribute[str] = _attribute("body", str)


class CallAction(InvocationAction):
    isSynchronous: _attribute[bool] = _attribute("isSynchronous", bool, default=True)
    result: relation_many[OutputPin]


class CallBehaviorAction(CallAction):
    behavior: relation_one[Behavior]


class ValueSpecificationAction(Action):
    result: relation_one[OutputPin]
    value: relation_one[ValueSpecification]


class Comment(Element):
    annotatedElement: relation_many[Element]
    body: _attribute[str] = _attribute("body", str)


from gaphor.core.modeling.diagram import Diagram as _Diagram
class Diagram(NamedElement, _Diagram):
    element: relation_one[Element]


class OpaqueBehavior(Behavior):
    body: _attribute[str] = _attribute("body", str)
    language: _attribute[str] = _attribute("language", str)


class FunctionalBehavior(OpaqueBehavior):
    pass


class StructureDiagram(Diagram):
    pass


class ProfileDiagram(StructureDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="prf")


class DeploymentDiagram(StructureDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="dep")


class ClassDiagram(StructureDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="cls")


class ComponentDiagram(StructureDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="cmp")


class PackageDiagram(StructureDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="pkg")


class BehaviorDiagram(Diagram):
    pass


class InteractionDiagram(BehaviorDiagram):
    pass


class CommunicationDiagram(InteractionDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="com")


class UseCaseDiagram(BehaviorDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="uc")


class ActivityDiagram(BehaviorDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="act")


class StateMachineDiagram(BehaviorDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="stm")


class SequenceDiagram(InteractionDiagram):
    diagramType: _attribute[str] = _attribute("diagramType", str, default="sd")


# 67: override Lifeline.parse: Callable[[Lifeline, str], None]
# defined in umloverrides.py

# 70: override Lifeline.render: Callable[[Lifeline], str]
# defined in umloverrides.py


Element.appliedStereotype = association("appliedStereotype", InstanceSpecification, composite=True, opposite="extended")
Element.relationship = derivedunion("relationship", Relationship)
Element.comment = association("comment", Comment, opposite="annotatedElement")
Element.owner = derivedunion("owner", Element, upper=1)
Element.ownedElement = derivedunion("ownedElement", Element)
Element.ownedDiagram = association("ownedDiagram", Diagram, composite=True, opposite="element")
Element.ownedElement.add(Element.ownedDiagram)  # type: ignore[attr-defined]
NamedElement.clientDependency = association("clientDependency", Dependency, composite=True, opposite="client")
NamedElement.supplierDependency = association("supplierDependency", Dependency, opposite="supplier")
NamedElement.memberNamespace = derivedunion("memberNamespace", Namespace, upper=1)
NamedElement.namespace = derivedunion("namespace", Namespace, upper=1)
# 20: override NamedElement.qualifiedName: property
# defined in umloverrides.py

NamedElement.memberNamespace.add(NamedElement.namespace)  # type: ignore[attr-defined]
Element.owner.add(NamedElement.namespace)  # type: ignore[attr-defined]
PackageableElement.owningPackage = association("owningPackage", Package, upper=1, opposite="packagedElement")
PackageableElement.component = association("component", Component, upper=1, opposite="packagedElement")
NamedElement.namespace.add(PackageableElement.owningPackage)  # type: ignore[attr-defined]
NamedElement.namespace.add(PackageableElement.component)  # type: ignore[attr-defined]
DeployedArtifact.deployment = association("deployment", Deployment, opposite="deployedArtifact")
DeploymentTarget.deployment = association("deployment", Deployment, composite=True, opposite="location")
Element.ownedElement.add(DeploymentTarget.deployment)  # type: ignore[attr-defined]
NamedElement.clientDependency.add(DeploymentTarget.deployment)  # type: ignore[attr-defined]
InstanceSpecification.slot = association("slot", Slot, composite=True, opposite="owningInstance")
InstanceSpecification.specification = association("specification", ValueSpecification, upper=1, composite=True)
InstanceSpecification.classifier = association("classifier", Classifier, opposite="instanceSpecification")
InstanceSpecification.extended = association("extended", Element, opposite="appliedStereotype")
Element.ownedElement.add(InstanceSpecification.slot)  # type: ignore[attr-defined]
Element.ownedElement.add(InstanceSpecification.specification)  # type: ignore[attr-defined]
EnumerationLiteral.enumeration = association("enumeration", Enumeration, upper=1, opposite="ownedLiteral")
NamedElement.namespace.add(EnumerationLiteral.enumeration)  # type: ignore[attr-defined]
Relationship.abstraction = association("abstraction", InformationFlow, composite=True, opposite="realization")
Relationship.relatedElement = derivedunion("relatedElement", Element, lower=1)
DirectedRelationship.target = derivedunion("target", Element, lower=1)
DirectedRelationship.source = derivedunion("source", Element, lower=1)
Relationship.relatedElement.add(DirectedRelationship.target)  # type: ignore[attr-defined]
Relationship.relatedElement.add(DirectedRelationship.source)  # type: ignore[attr-defined]
PackageMerge.mergingPackage = association("mergingPackage", Package, upper=1, opposite="packageMerge")
PackageMerge.mergedPackage = association("mergedPackage", Package, upper=1)
DirectedRelationship.source.add(PackageMerge.mergingPackage)  # type: ignore[attr-defined]
Element.owner.add(PackageMerge.mergingPackage)  # type: ignore[attr-defined]
DirectedRelationship.target.add(PackageMerge.mergedPackage)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement = derivedunion("redefinedElement", RedefinableElement)
RedefinableElement.redefinitionContext = derivedunion("redefinitionContext", Classifier)
# 55: override Namespace.importedMember: derivedunion[PackageableElement]
Namespace.importedMember = derivedunion('importedMember', PackageableElement, 0, '*')

Namespace.elementImport = association("elementImport", ElementImport, composite=True, opposite="importingNamespace")
Namespace.packageImport = association("packageImport", PackageImport, composite=True, opposite="importingNamespace")
Namespace.ownedRule = association("ownedRule", Constraint, composite=True, opposite="context")
Namespace.member = derivedunion("member", NamedElement)
Namespace.ownedMember = derivedunion("ownedMember", NamedElement)
Element.ownedElement.add(Namespace.elementImport)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.packageImport)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Namespace.ownedRule)  # type: ignore[attr-defined]
Namespace.member.add(Namespace.ownedMember)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.ownedMember)  # type: ignore[attr-defined]
Type.package = association("package", Package, upper=1, opposite="ownedType")
PackageableElement.owningPackage.add(Type.package)  # type: ignore[attr-defined]
Classifier.componentRealization = association("componentRealization", ComponentRealization, opposite="realizingClassifier")
Classifier.generalization = association("generalization", Generalization, composite=True, opposite="specific")
Classifier.instanceSpecification = association("instanceSpecification", InstanceSpecification, composite=True, opposite="classifier")
Classifier.ownedUseCase = association("ownedUseCase", UseCase, composite=True)
Classifier.specialization = association("specialization", Generalization, opposite="general")
Classifier.redefinedClassifier = association("redefinedClassifier", Classifier)
# 46: override Classifier.inheritedMember: derivedunion[NamedElement]
Classifier.inheritedMember = derivedunion('inheritedMember', NamedElement, 0, '*')

Classifier.attribute = derivedunion("attribute", Property)
# 49: override Classifier.general(Generalization.general): derived[Classifier]
Classifier.general = derived('general', Classifier, 0, '*', lambda self: [g.general for g in self.generalization])

Classifier.useCase = association("useCase", UseCase, opposite="subject")
Classifier.nestingClass = association("nestingClass", Class, upper=1, opposite="nestedClassifier")
Classifier.feature = derivedunion("feature", Feature)
NamedElement.clientDependency.add(Classifier.componentRealization)  # type: ignore[attr-defined]
Element.ownedElement.add(Classifier.generalization)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Classifier.ownedUseCase)  # type: ignore[attr-defined]
Element.relationship.add(Classifier.specialization)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Classifier.redefinedClassifier)  # type: ignore[attr-defined]
Namespace.member.add(Classifier.inheritedMember)  # type: ignore[attr-defined]
Classifier.feature.add(Classifier.attribute)  # type: ignore[attr-defined]
NamedElement.namespace.add(Classifier.nestingClass)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Classifier.nestingClass)  # type: ignore[attr-defined]
# 23: override Association.endType(Association.memberEnd, Property.type): derived[Type]

# References the classifiers that are used as types of the ends of the
# association.

Association.endType = derived('endType', Type, 0, '*', lambda self: [end.type for end in self.memberEnd if end])


Association.ownedEnd = association("ownedEnd", Property, composite=True, opposite="owningAssociation")
Association.memberEnd = association("memberEnd", Property, lower=2, composite=True, opposite="association")
Association.navigableOwnedEnd = association("navigableOwnedEnd", Property, opposite="association2")
Classifier.feature.add(Association.ownedEnd)  # type: ignore[attr-defined]
Association.memberEnd.add(Association.ownedEnd)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Association.ownedEnd)  # type: ignore[attr-defined]
Namespace.member.add(Association.memberEnd)  # type: ignore[attr-defined]
Association.ownedEnd.add(Association.navigableOwnedEnd)  # type: ignore[attr-defined]
# 43: override Extension.metaclass(Extension.ownedEnd, Association.memberEnd): property
# defined in umloverrides.py

Extension.ownedEnd = association("ownedEnd", ExtensionEnd, upper=1, composite=True)
BehavioredClassifier.interfaceRealization = association("interfaceRealization", InterfaceRealization, composite=True, opposite="implementingClassifier")
BehavioredClassifier.ownedBehavior = association("ownedBehavior", Behavior, composite=True, opposite="behavioredClassifier")
BehavioredClassifier.classifierBehavior = association("classifierBehavior", Behavior, upper=1, opposite="behavioredClassifier_")
BehavioredClassifier.behavior = association("behavior", Behavior, opposite="context")
NamedElement.supplierDependency.add(BehavioredClassifier.interfaceRealization)  # type: ignore[attr-defined]
Namespace.ownedMember.add(BehavioredClassifier.ownedBehavior)  # type: ignore[attr-defined]
BehavioredClassifier.classifierBehavior.add(BehavioredClassifier.classifierBehavior)  # type: ignore[attr-defined]
ActivityNode.incoming = association("incoming", ActivityEdge, opposite="target")
ActivityNode.outgoing = association("outgoing", ActivityEdge, opposite="source")
ActivityNode.inPartition = association("inPartition", ActivityPartition, opposite="node")
ActivityNode.activity = association("activity", Activity, upper=1, opposite="node")
ActivityNode.inGroup = association("inGroup", ActivityGroup, opposite="nodeContents")
ActivityNode.redefinedElement = redefine(ActivityNode, "redefinedElement", ActivityNode, RedefinableElement.redefinedElement)
ActivityNode.inGroup.add(ActivityNode.inPartition)  # type: ignore[attr-defined]
Element.owner.add(ActivityNode.activity)  # type: ignore[attr-defined]
Feature.featuringClassifier = derivedunion("featuringClassifier", Classifier, lower=1)
ActivityEdge.source = association("source", ActivityNode, upper=1, opposite="outgoing")
ActivityEdge.activity = association("activity", Activity, upper=1, opposite="edge")
ActivityEdge.target = association("target", ActivityNode, upper=1, opposite="incoming")
ActivityEdge.guard = association("guard", ValueSpecification, upper=1, composite=True, opposite="activityEdge")
ActivityEdge.inGroup = association("inGroup", ActivityGroup, opposite="edgeContents")
ActivityEdge.weight = association("weight", ValueSpecification, upper=1, composite=True)
ActivityEdge.redefinedElement = redefine(ActivityEdge, "redefinedElement", ActivityEdge, RedefinableElement.redefinedElement)
Element.owner.add(ActivityEdge.activity)  # type: ignore[attr-defined]
Element.ownedElement.add(ActivityEdge.guard)  # type: ignore[attr-defined]
Element.ownedElement.add(ActivityEdge.weight)  # type: ignore[attr-defined]
TypedElement.type = association("type", Type, upper=1)
ValueSpecification.owningLower = association("owningLower", MultiplicityElement, upper=1, opposite="lowerValue")
ValueSpecification.activityEdge = association("activityEdge", ActivityEdge, upper=1, opposite="guard")
ValueSpecification.owningParameter = association("owningParameter", Parameter, upper=1, opposite="defaultValue")
ValueSpecification.owningSlot = association("owningSlot", Slot, upper=1, opposite="value")
ValueSpecification.owningUpper = association("owningUpper", MultiplicityElement, upper=1, opposite="upperValue")
ValueSpecification.changeEvent = association("changeEvent", ChangeEvent, upper=1, opposite="changeExpression")
ValueSpecification.lifeline = association("lifeline", Lifeline, upper=1, opposite="selector")
ValueSpecification.owningProperty = association("owningProperty", Property, upper=1, opposite="defaultValue")
ValueSpecification.joinNode = association("joinNode", JoinNode, upper=1, opposite="joinSpec")
ValueSpecification.objectNode = association("objectNode", ObjectNode, upper=1, opposite="upperBound")
ValueSpecification.owningConstraint = association("owningConstraint", Constraint, upper=1, opposite="specification")
ValueSpecification.valueSpecificationAction = association("valueSpecificationAction", ValueSpecificationAction, upper=1, opposite="value")
Element.owner.add(ValueSpecification.owningLower)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.activityEdge)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.owningParameter)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.owningSlot)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.owningUpper)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.owningProperty)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.joinNode)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.objectNode)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.owningConstraint)  # type: ignore[attr-defined]
Element.owner.add(ValueSpecification.valueSpecificationAction)  # type: ignore[attr-defined]
Dependency.client = association("client", NamedElement, lower=1, opposite="clientDependency")
Dependency.supplier = association("supplier", NamedElement, lower=1, opposite="supplierDependency")
DirectedRelationship.source.add(Dependency.client)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Dependency.supplier)  # type: ignore[attr-defined]
ObjectNode.selection = association("selection", Behavior, upper=1)
ObjectNode.upperBound = association("upperBound", ValueSpecification, upper=1, composite=True, opposite="objectNode")
Element.ownedElement.add(ObjectNode.upperBound)  # type: ignore[attr-defined]
MultiplicityElement.upperValue = association("upperValue", ValueSpecification, upper=1, composite=True, opposite="owningUpper")
MultiplicityElement.lowerValue = association("lowerValue", ValueSpecification, upper=1, composite=True, opposite="owningLower")
Element.ownedElement.add(MultiplicityElement.upperValue)  # type: ignore[attr-defined]
Element.ownedElement.add(MultiplicityElement.lowerValue)  # type: ignore[attr-defined]
Generalization.general = association("general", Classifier, upper=1, opposite="specialization")
Generalization.specific = association("specific", Classifier, upper=1, opposite="generalization")
Relationship.relatedElement.add(Generalization.general)  # type: ignore[attr-defined]
DirectedRelationship.source.add(Generalization.specific)  # type: ignore[attr-defined]
Element.owner.add(Generalization.specific)  # type: ignore[attr-defined]
StructuredClassifier.role = derivedunion("role", ConnectableElement)
StructuredClassifier.ownedConnector = association("ownedConnector", Connector, composite=True, opposite="structuredClassifier")
StructuredClassifier.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="structuredClassifier")
# 82: override StructuredClassifier.part: property
StructuredClassifier.part = property(lambda self: tuple(a for a in self.ownedAttribute if a.isComposite), doc="""
    Properties owned by a classifier by composition.
""")

Namespace.member.add(StructuredClassifier.role)  # type: ignore[attr-defined]
Namespace.ownedMember.add(StructuredClassifier.ownedConnector)  # type: ignore[attr-defined]
Classifier.feature.add(StructuredClassifier.ownedConnector)  # type: ignore[attr-defined]
StructuredClassifier.role.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
Classifier.attribute.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
EncapsulatedClassifier.ownedPort = association("ownedPort", Port, composite=True, opposite="encapsulatedClassifier")
StructuredClassifier.role.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Classifier.attribute.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Namespace.ownedMember.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Class.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="class_")
# 31: override Class.extension(Extension.metaclass): property
# See https://www.omg.org/spec/UML/2.5/PDF, section 11.8.3.6, page 219
# It defines `Extension.allInstances()`, which basically means we have to query the element factory.

# TODO: use those as soon as Extension.metaclass can be used.
#Class.extension = derived('extension', Extension, 0, '*', class_extension, Extension.metaclass)

Class.extension = property(lambda self: self.model.lselect(lambda e: e.isKindOf(Extension) and self is e.metaclass), doc=\
"""References the Extensions that specify additional properties of the
metaclass. The property is derived from the extensions whose memberEnds
are typed by the Class.""")

# 52: override Class.superClass: derived[Classifier]
Class.superClass = Classifier.general

Class.nestedClassifier = association("nestedClassifier", Classifier, composite=True, opposite="nestingClass")
Class.ownedAttribute = redefine(Class, "ownedAttribute", Property, StructuredClassifier.ownedAttribute, opposite="class_")
Classifier.attribute.add(Class.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.ownedAttribute)  # type: ignore[attr-defined]
Classifier.feature.add(Class.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.nestedClassifier)  # type: ignore[attr-defined]
Node.nestedNode = association("nestedNode", Node, composite=True, opposite="node")
Node.node = association("node", Node, upper=1, opposite="nestedNode")
Namespace.ownedMember.add(Node.nestedNode)  # type: ignore[attr-defined]
NamedElement.namespace.add(Node.node)  # type: ignore[attr-defined]
StructuralFeature.slot = association("slot", Slot, composite=True, opposite="definingFeature")
UseCase.extensionPoint = association("extensionPoint", ExtensionPoint, composite=True, opposite="useCase")
UseCase.subject = association("subject", Classifier, opposite="useCase")
UseCase.extend = association("extend", Extend, composite=True, opposite="extension")
UseCase.include = association("include", Include, composite=True, opposite="includingCase")
Namespace.ownedMember.add(UseCase.extensionPoint)  # type: ignore[attr-defined]
Element.relationship.add(UseCase.extend)  # type: ignore[attr-defined]
Namespace.ownedMember.add(UseCase.extend)  # type: ignore[attr-defined]
Element.relationship.add(UseCase.include)  # type: ignore[attr-defined]
Namespace.ownedMember.add(UseCase.include)  # type: ignore[attr-defined]
InputPin.opaqueAction = association("opaqueAction", Action, upper=1, opposite="inputValue")
Element.owner.add(InputPin.opaqueAction)  # type: ignore[attr-defined]
Manifestation.artifact = association("artifact", Artifact, upper=1, opposite="manifestation")
Dependency.client.add(Manifestation.artifact)  # type: ignore[attr-defined]
Element.owner.add(Manifestation.artifact)  # type: ignore[attr-defined]
# 73: override Component.provided: property
# defined in umloverrides.py

Component.packagedElement = association("packagedElement", PackageableElement, composite=True, opposite="component")
Component.realization = association("realization", ComponentRealization, opposite="abstraction")
# 76: override Component.required: property
# defined in umloverrides.py

Namespace.ownedMember.add(Component.packagedElement)  # type: ignore[attr-defined]
Element.ownedElement.add(Component.realization)  # type: ignore[attr-defined]
NamedElement.supplierDependency.add(Component.realization)  # type: ignore[attr-defined]
ConnectableElement.end = association("end", ConnectorEnd, opposite="role")
ConnectableElement.lifeline = association("lifeline", Lifeline, opposite="represents")
Interface.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="interface_")
Interface.nestedClassifier = association("nestedClassifier", Classifier, composite=True)
Interface.redefinedInterface = association("redefinedInterface", Interface)
Interface.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="interface_")
Interface.interfaceRealization = association("interfaceRealization", InterfaceRealization, opposite="contract")
Classifier.feature.add(Interface.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interface.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interface.nestedClassifier)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Interface.redefinedInterface)  # type: ignore[attr-defined]
Classifier.attribute.add(Interface.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interface.ownedAttribute)  # type: ignore[attr-defined]
Element.ownedElement.add(Interface.interfaceRealization)  # type: ignore[attr-defined]
NamedElement.clientDependency.add(Interface.interfaceRealization)  # type: ignore[attr-defined]
Include.addition = association("addition", UseCase, upper=1)
Include.includingCase = association("includingCase", UseCase, upper=1, opposite="include")
DirectedRelationship.target.add(Include.addition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Include.includingCase)  # type: ignore[attr-defined]
Relationship.relatedElement.add(Include.includingCase)  # type: ignore[attr-defined]
ProfileApplication.appliedProfile = association("appliedProfile", Profile, upper=1)
ExtensionPoint.useCase = association("useCase", UseCase, upper=1, opposite="extensionPoint")
NamedElement.namespace.add(ExtensionPoint.useCase)  # type: ignore[attr-defined]
ElementImport.importingNamespace = association("importingNamespace", Namespace, upper=1, opposite="elementImport")
ElementImport.importedElement = association("importedElement", PackageableElement, upper=1)
DirectedRelationship.source.add(ElementImport.importingNamespace)  # type: ignore[attr-defined]
Element.owner.add(ElementImport.importingNamespace)  # type: ignore[attr-defined]
DirectedRelationship.target.add(ElementImport.importedElement)  # type: ignore[attr-defined]
Property.interface_ = association("interface_", Interface, upper=1, opposite="ownedAttribute")
Property.association = association("association", Association, upper=1, opposite="memberEnd")
Property.owningAssociation = association("owningAssociation", Association, upper=1, opposite="ownedEnd")
Property.classifier = derivedunion("classifier", Classifier, upper=1)
# 58: override Property.isComposite(Property.aggregation): derived[bool]
Property.isComposite = derived('isComposite', bool, 0, 1, lambda obj: [obj.aggregation == 'composite'])

Property.datatype = association("datatype", DataType, upper=1, opposite="ownedAttribute")
Property.redefinedProperty = association("redefinedProperty", Property)
Property.defaultValue = association("defaultValue", ValueSpecification, upper=1, composite=True, opposite="owningProperty")
Property.subsettedProperty = association("subsettedProperty", Property)
Property.opposite = derivedunion("opposite", Property, upper=1)
Property.artifact = association("artifact", Artifact, upper=1, opposite="ownedAttribute")
# 61: override Property.navigability(Property.opposite, Property.association): derived[bool | None]
# defined in umloverrides.py

Property.structuredClassifier = association("structuredClassifier", StructuredClassifier, upper=1, opposite="ownedAttribute")
Property.association2 = association("association2", Association, upper=1, opposite="navigableOwnedEnd")
Property.class_ = redefine(Property, "class_", Class, Property.structuredClassifier, opposite="ownedAttribute")
Property.classifier.add(Property.interface_)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.interface_)  # type: ignore[attr-defined]
Property.classifier.add(Property.class_)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.class_)  # type: ignore[attr-defined]
NamedElement.memberNamespace.add(Property.association)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.owningAssociation)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Property.owningAssociation)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Property.owningAssociation)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Property.classifier)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.datatype)  # type: ignore[attr-defined]
Property.classifier.add(Property.datatype)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Property.redefinedProperty)  # type: ignore[attr-defined]
Element.ownedElement.add(Property.defaultValue)  # type: ignore[attr-defined]
Property.classifier.add(Property.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.artifact)  # type: ignore[attr-defined]
Property.classifier.add(Property.structuredClassifier)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.structuredClassifier)  # type: ignore[attr-defined]
ExtensionEnd.type = redefine(ExtensionEnd, "type", Stereotype, Property.type)
DataType.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="datatype")
DataType.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="datatype")
Classifier.feature.add(DataType.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(DataType.ownedOperation)  # type: ignore[attr-defined]
Classifier.attribute.add(DataType.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(DataType.ownedAttribute)  # type: ignore[attr-defined]
Enumeration.ownedLiteral = association("ownedLiteral", EnumerationLiteral, composite=True, opposite="enumeration")
Namespace.ownedMember.add(Enumeration.ownedLiteral)  # type: ignore[attr-defined]
Slot.owningInstance = association("owningInstance", InstanceSpecification, upper=1, opposite="slot")
Slot.value = association("value", ValueSpecification, upper=1, composite=True, opposite="owningSlot")
Slot.definingFeature = association("definingFeature", StructuralFeature, upper=1, opposite="slot")
Element.owner.add(Slot.owningInstance)  # type: ignore[attr-defined]
Element.ownedElement.add(Slot.value)  # type: ignore[attr-defined]
Stereotype.profile = derivedunion("profile", Profile, upper=1)
Stereotype.icon = association("icon", Image, composite=True)
Namespace.ownedMember.add(Stereotype.icon)  # type: ignore[attr-defined]
Artifact.manifestation = association("manifestation", Manifestation, composite=True, opposite="artifact")
Artifact.nestedArtifact = association("nestedArtifact", Artifact, composite=True, opposite="artifact")
Artifact.artifact = association("artifact", Artifact, upper=1, opposite="nestedArtifact")
Artifact.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="artifact")
Artifact.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="artifact")
Element.ownedElement.add(Artifact.manifestation)  # type: ignore[attr-defined]
NamedElement.clientDependency.add(Artifact.manifestation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.nestedArtifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Artifact.artifact)  # type: ignore[attr-defined]
Classifier.attribute.add(Artifact.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.ownedAttribute)  # type: ignore[attr-defined]
Classifier.feature.add(Artifact.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.ownedOperation)  # type: ignore[attr-defined]
ActivityParameterNode.parameter = association("parameter", Parameter, upper=1, composite=True, opposite="activityParameterNode")
DecisionNode.decisionInput = association("decisionInput", Behavior, upper=1)
Package.packagedElement = association("packagedElement", PackageableElement, composite=True, opposite="owningPackage")
Package.ownedType = association("ownedType", Type, composite=True, opposite="package")
Package.packageMerge = association("packageMerge", PackageMerge, composite=True, opposite="mergingPackage")
Package.appliedProfile = association("appliedProfile", ProfileApplication, composite=True)
Package.nestingPackage = association("nestingPackage", Package, upper=1, opposite="nestedPackage")
Package.nestedPackage = association("nestedPackage", Package, composite=True, opposite="nestingPackage")
Namespace.ownedMember.add(Package.packagedElement)  # type: ignore[attr-defined]
Package.packagedElement.add(Package.ownedType)  # type: ignore[attr-defined]
Element.ownedElement.add(Package.packageMerge)  # type: ignore[attr-defined]
Element.ownedElement.add(Package.appliedProfile)  # type: ignore[attr-defined]
PackageableElement.owningPackage.add(Package.nestingPackage)  # type: ignore[attr-defined]
Package.packagedElement.add(Package.nestedPackage)  # type: ignore[attr-defined]
Profile.metamodelReference = association("metamodelReference", PackageImport, composite=True)
Profile.metaclassReference = association("metaclassReference", ElementImport, composite=True)
Namespace.packageImport.add(Profile.metamodelReference)  # type: ignore[attr-defined]
Namespace.elementImport.add(Profile.metaclassReference)  # type: ignore[attr-defined]
Behavior.redefinedBehavior = association("redefinedBehavior", Behavior)
Behavior.behavioredClassifier = association("behavioredClassifier", BehavioredClassifier, upper=1, opposite="ownedBehavior")
Behavior.action_transition = association("action_transition", Transition, upper=1, opposite="action")
Behavior.trigger_transition = association("trigger_transition", Transition, upper=1, opposite="trigger")
Behavior.ownedParameter = association("ownedParameter", Parameter, composite=True, opposite="behavior")
Behavior.ownedParameterSet = association("ownedParameterSet", ParameterSet, composite=True, opposite="behavior")
Behavior.behavioredClassifier_ = association("behavioredClassifier_", BehavioredClassifier, upper=1, opposite="classifierBehavior")
Behavior.context = derivedunion("context", BehavioredClassifier, upper=1)
RedefinableElement.redefinedElement.add(Behavior.redefinedBehavior)  # type: ignore[attr-defined]
NamedElement.namespace.add(Behavior.behavioredClassifier)  # type: ignore[attr-defined]
Element.owner.add(Behavior.action_transition)  # type: ignore[attr-defined]
Element.owner.add(Behavior.trigger_transition)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Behavior.ownedParameter)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Behavior.ownedParameterSet)  # type: ignore[attr-defined]
Behavior.behavioredClassifier.add(Behavior.behavioredClassifier_)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Behavior.context)  # type: ignore[attr-defined]
Activity.group = association("group", ActivityGroup, composite=True, opposite="activity")
Activity.edge = association("edge", ActivityEdge, composite=True, opposite="activity")
Activity.node = association("node", ActivityNode, composite=True, opposite="activity")
Element.ownedElement.add(Activity.group)  # type: ignore[attr-defined]
Element.ownedElement.add(Activity.edge)  # type: ignore[attr-defined]
Element.ownedElement.add(Activity.node)  # type: ignore[attr-defined]
InterfaceRealization.contract = association("contract", Interface, upper=1, opposite="interfaceRealization")
InterfaceRealization.implementingClassifier = association("implementingClassifier", BehavioredClassifier, upper=1, opposite="interfaceRealization")
Dependency.supplier.add(InterfaceRealization.contract)  # type: ignore[attr-defined]
Dependency.client.add(InterfaceRealization.implementingClassifier)  # type: ignore[attr-defined]
Element.owner.add(InterfaceRealization.implementingClassifier)  # type: ignore[attr-defined]
Parameter.activityParameterNode = association("activityParameterNode", ActivityParameterNode, opposite="parameter")
Parameter.defaultValue = association("defaultValue", ValueSpecification, upper=1, composite=True, opposite="owningParameter")
Parameter.parameterSet = association("parameterSet", ParameterSet, opposite="parameter")
Parameter.ownerFormalParam = association("ownerFormalParam", BehavioralFeature, upper=1, opposite="ownedParameter")
Parameter.behavior = association("behavior", Behavior, upper=1, opposite="ownedParameter")
Parameter.operation = redefine(Parameter, "operation", Operation, Parameter.ownerFormalParam, opposite="ownedParameter")
Element.ownedElement.add(Parameter.defaultValue)  # type: ignore[attr-defined]
NamedElement.namespace.add(Parameter.ownerFormalParam)  # type: ignore[attr-defined]
NamedElement.namespace.add(Parameter.behavior)  # type: ignore[attr-defined]
BehavioralFeature.raisedException = association("raisedException", Type)
BehavioralFeature.ownedParameter = association("ownedParameter", Parameter, composite=True, opposite="ownerFormalParam")
BehavioralFeature.method = association("method", Behavior)
BehavioralFeature.ownedParameterSet = association("ownedParameterSet", ParameterSet, upper=1, composite=True, opposite="behavioralFeature")
Namespace.ownedMember.add(BehavioralFeature.ownedParameter)  # type: ignore[attr-defined]
Namespace.ownedMember.add(BehavioralFeature.ownedParameterSet)  # type: ignore[attr-defined]
Operation.precondition = association("precondition", Constraint, composite=True)
Operation.postcondition = association("postcondition", Constraint, composite=True)
Operation.class_ = association("class_", Class, upper=1, opposite="ownedOperation")
Operation.redefinedOperation = association("redefinedOperation", Operation)
Operation.raisedException = association("raisedException", Type)
Operation.bodyCondition = association("bodyCondition", Constraint, upper=1, composite=True)
Operation.datatype = association("datatype", DataType, upper=1, opposite="ownedOperation")
# 64: override Operation.type: derivedunion[DataType]
Operation.type = derivedunion('type', DataType, 0, 1)

Operation.artifact = association("artifact", Artifact, upper=1, opposite="ownedOperation")
Operation.interface_ = association("interface_", Interface, upper=1, opposite="ownedOperation")
Operation.ownedParameter = redefine(Operation, "ownedParameter", Parameter, BehavioralFeature.ownedParameter, opposite="operation")
Namespace.ownedMember.add(Operation.precondition)  # type: ignore[attr-defined]
Namespace.ownedRule.add(Operation.precondition)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Operation.postcondition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.class_)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.class_)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.class_)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Operation.redefinedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Operation.bodyCondition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.datatype)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.datatype)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.datatype)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.artifact)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.interface_)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.interface_)  # type: ignore[attr-defined]
OutputPin.opaqueAction = association("opaqueAction", Action, upper=1, opposite="outputValue")
Element.owner.add(OutputPin.opaqueAction)  # type: ignore[attr-defined]
ValuePin.value_ = association("value_", ValueSpecification, upper=1, composite=True)
Action.context_ = derivedunion("context_", Classifier, upper=1)
Action.interaction = association("interaction", Interaction, upper=1, opposite="action")
Action.outputValue = association("outputValue", OutputPin, composite=True, opposite="opaqueAction")
Action.inputValue = association("inputValue", InputPin, composite=True, opposite="opaqueAction")
Element.owner.add(Action.interaction)  # type: ignore[attr-defined]
Element.ownedElement.add(Action.outputValue)  # type: ignore[attr-defined]
Element.ownedElement.add(Action.inputValue)  # type: ignore[attr-defined]
Extend.extension = association("extension", UseCase, upper=1, opposite="extend")
Extend.extensionLocation = association("extensionLocation", ExtensionPoint, lower=1)
Extend.extendedCase = association("extendedCase", UseCase, upper=1)
Extend.constraint = association("constraint", Constraint, upper=1, composite=True)
NamedElement.namespace.add(Extend.extension)  # type: ignore[attr-defined]
Relationship.relatedElement.add(Extend.extension)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Extend.extendedCase)  # type: ignore[attr-defined]
ActivityGroup.nodeContents = association("nodeContents", ActivityNode, opposite="inGroup")
ActivityGroup.edgeContents = association("edgeContents", ActivityEdge, opposite="inGroup")
ActivityGroup.superGroup = derivedunion("superGroup", ActivityGroup, upper=1)
ActivityGroup.activity = association("activity", Activity, upper=1, opposite="group")
ActivityGroup.subgroup = derivedunion("subgroup", ActivityGroup)
Element.owner.add(ActivityGroup.superGroup)  # type: ignore[attr-defined]
Element.owner.add(ActivityGroup.activity)  # type: ignore[attr-defined]
Element.ownedElement.add(ActivityGroup.subgroup)  # type: ignore[attr-defined]
Constraint.specification = association("specification", ValueSpecification, upper=1, composite=True, opposite="owningConstraint")
Constraint.constrainedElement = association("constrainedElement", Element)
Constraint.owningState = association("owningState", State, upper=1, opposite="statevariant")
Constraint.stateInvariant = association("stateInvariant", StateInvariant, upper=1, opposite="invariant")
Constraint.parameterSet = association("parameterSet", ParameterSet, upper=1, opposite="condition")
Constraint.transition = association("transition", Transition, upper=1, opposite="guard")
Constraint.context = association("context", Namespace, upper=1, opposite="ownedRule")
Element.ownedElement.add(Constraint.specification)  # type: ignore[attr-defined]
Element.owner.add(Constraint.stateInvariant)  # type: ignore[attr-defined]
Element.owner.add(Constraint.parameterSet)  # type: ignore[attr-defined]
Element.owner.add(Constraint.transition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Constraint.context)  # type: ignore[attr-defined]
PackageImport.importedPackage = association("importedPackage", Package, upper=1)
PackageImport.importingNamespace = association("importingNamespace", Namespace, upper=1, opposite="packageImport")
DirectedRelationship.target.add(PackageImport.importedPackage)  # type: ignore[attr-defined]
DirectedRelationship.source.add(PackageImport.importingNamespace)  # type: ignore[attr-defined]
Element.owner.add(PackageImport.importingNamespace)  # type: ignore[attr-defined]
InteractionFragment.generalOrdering = association("generalOrdering", GeneralOrdering, composite=True, opposite="interactionFragment")
InteractionFragment.enclosingInteraction = association("enclosingInteraction", Interaction, upper=1, opposite="fragment")
InteractionFragment.covered = association("covered", Lifeline, upper=1, opposite="coveredBy")
Element.ownedElement.add(InteractionFragment.generalOrdering)  # type: ignore[attr-defined]
NamedElement.namespace.add(InteractionFragment.enclosingInteraction)  # type: ignore[attr-defined]
Interaction.lifeline = association("lifeline", Lifeline, composite=True, opposite="interaction")
Interaction.action = association("action", Action, composite=True, opposite="interaction")
Interaction.fragment = association("fragment", InteractionFragment, opposite="enclosingInteraction")
Interaction.message = association("message", Message, composite=True, opposite="interaction")
Namespace.ownedMember.add(Interaction.lifeline)  # type: ignore[attr-defined]
Element.ownedElement.add(Interaction.action)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interaction.fragment)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interaction.message)  # type: ignore[attr-defined]
StateInvariant.invariant = association("invariant", Constraint, upper=1, composite=True, opposite="stateInvariant")
StateInvariant.covered = redefine(StateInvariant, "covered", Lifeline, InteractionFragment.covered)
Element.ownedElement.add(StateInvariant.invariant)  # type: ignore[attr-defined]
Lifeline.interaction = association("interaction", Interaction, upper=1, opposite="lifeline")
Lifeline.coveredBy = association("coveredBy", InteractionFragment, opposite="covered")
Lifeline.selector = association("selector", ValueSpecification, upper=1, composite=True, opposite="lifeline")
Lifeline.represents = association("represents", ConnectableElement, upper=1, opposite="lifeline")
NamedElement.namespace.add(Lifeline.interaction)  # type: ignore[attr-defined]
# 79: override Message.messageKind: property
# defined in umloverrides.py

Message.sendEvent = association("sendEvent", MessageEnd, upper=1, composite=True, opposite="sendMessage")
Message.receiveEvent = association("receiveEvent", MessageEnd, upper=1, composite=True, opposite="receiveMessage")
Message.signature = association("signature", NamedElement, upper=1)
Message.messageEnd = derivedunion("messageEnd", MessageEnd, upper=2)
Message.interaction = association("interaction", Interaction, upper=1, opposite="message")
Message.argument = association("argument", ValueSpecification, upper=1, composite=True)
Message.messageEnd.add(Message.sendEvent)  # type: ignore[attr-defined]
Message.messageEnd.add(Message.receiveEvent)  # type: ignore[attr-defined]
NamedElement.namespace.add(Message.interaction)  # type: ignore[attr-defined]
Element.ownedElement.add(Message.argument)  # type: ignore[attr-defined]
MessageEnd.sendMessage = association("sendMessage", Message, upper=1, opposite="sendEvent")
MessageEnd.receiveMessage = association("receiveMessage", Message, upper=1, opposite="receiveEvent")
MessageEnd.message = derivedunion("message", Message, upper=1)
MessageEnd.message.add(MessageEnd.sendMessage)  # type: ignore[attr-defined]
MessageEnd.message.add(MessageEnd.receiveMessage)  # type: ignore[attr-defined]
OccurrenceSpecification.covered = redefine(OccurrenceSpecification, "covered", Lifeline, InteractionFragment.covered)
GeneralOrdering.interactionFragment = association("interactionFragment", InteractionFragment, upper=1, opposite="generalOrdering")
Element.owner.add(GeneralOrdering.interactionFragment)  # type: ignore[attr-defined]
Connector.end = association("end", ConnectorEnd, lower=2, composite=True)
Connector.type = association("type", Association, upper=1)
Connector.contract = association("contract", Behavior)
Connector.redefinedConnector = association("redefinedConnector", Connector)
Connector.structuredClassifier = association("structuredClassifier", StructuredClassifier, upper=1, opposite="ownedConnector")
Connector.informationFlow = association("informationFlow", InformationFlow, composite=True, opposite="realizingConnector")
Element.ownedElement.add(Connector.end)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Connector.redefinedConnector)  # type: ignore[attr-defined]
NamedElement.namespace.add(Connector.structuredClassifier)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Connector.structuredClassifier)  # type: ignore[attr-defined]
Element.ownedElement.add(Connector.informationFlow)  # type: ignore[attr-defined]
ConnectorEnd.definingEnd = derivedunion("definingEnd", Property, upper=1)
ConnectorEnd.role = association("role", ConnectableElement, upper=1, opposite="end")
ConnectorEnd.partWithPort = association("partWithPort", Property, upper=1)
JoinNode.joinSpec = association("joinSpec", ValueSpecification, upper=1, composite=True, opposite="joinNode")
Element.ownedElement.add(JoinNode.joinSpec)  # type: ignore[attr-defined]
StateMachine.region = association("region", Region, lower=1, composite=True, opposite="stateMachine")
Namespace.ownedMember.add(StateMachine.region)  # type: ignore[attr-defined]
Region.stateMachine = association("stateMachine", StateMachine, upper=1, opposite="region")
Region.subvertex = association("subvertex", Vertex, composite=True, opposite="container")
Region.state = association("state", State, upper=1, opposite="region")
NamedElement.namespace.add(Region.stateMachine)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Region.subvertex)  # type: ignore[attr-defined]
NamedElement.namespace.add(Region.state)  # type: ignore[attr-defined]
Transition.container = association("container", Region, upper=1)
Transition.effect = association("effect", Behavior, upper=1, composite=True)
Transition.guard = association("guard", Constraint, upper=1, composite=True, opposite="transition")
Transition.action = association("action", Behavior, upper=1, composite=True, opposite="action_transition")
Transition.trigger = association("trigger", Behavior, upper=1, composite=True, opposite="trigger_transition")
Transition.target = association("target", Vertex, upper=1, opposite="incoming")
Transition.source = association("source", Vertex, upper=1, opposite="outgoing")
NamedElement.namespace.add(Transition.container)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.effect)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.guard)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.action)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.trigger)  # type: ignore[attr-defined]
Vertex.container = association("container", Region, upper=1, opposite="subvertex")
Vertex.incoming = association("incoming", Transition, opposite="target")
Vertex.outgoing = association("outgoing", Transition, opposite="source")
NamedElement.namespace.add(Vertex.container)  # type: ignore[attr-defined]
Pseudostate.state = association("state", State, upper=1)
Pseudostate.stateMachine = association("stateMachine", StateMachine, upper=1)
Element.owner.add(Pseudostate.state)  # type: ignore[attr-defined]
NamedElement.namespace.add(Pseudostate.stateMachine)  # type: ignore[attr-defined]
ConnectionPointReference.exit = association("exit", Pseudostate)
ConnectionPointReference.entry = association("entry", Pseudostate)
ConnectionPointReference.state = association("state", State, upper=1)
NamedElement.namespace.add(ConnectionPointReference.state)  # type: ignore[attr-defined]
State.entry = association("entry", Behavior, upper=1, composite=True)
State.exit = association("exit", Behavior, upper=1, composite=True)
State.doActivity = association("doActivity", Behavior, upper=1, composite=True)
State.statevariant = association("statevariant", Constraint, upper=1, composite=True, opposite="owningState")
State.submachine = association("submachine", StateMachine, upper=1)
State.region = association("region", Region, composite=True, opposite="state")
Element.ownedElement.add(State.entry)  # type: ignore[attr-defined]
Element.ownedElement.add(State.exit)  # type: ignore[attr-defined]
Element.ownedElement.add(State.doActivity)  # type: ignore[attr-defined]
Element.ownedElement.add(State.statevariant)  # type: ignore[attr-defined]
Namespace.ownedMember.add(State.region)  # type: ignore[attr-defined]
Port.encapsulatedClassifier = association("encapsulatedClassifier", EncapsulatedClassifier, upper=1, opposite="ownedPort")
Property.classifier.add(Port.encapsulatedClassifier)  # type: ignore[attr-defined]
NamedElement.namespace.add(Port.encapsulatedClassifier)  # type: ignore[attr-defined]
Deployment.location = association("location", DeploymentTarget, upper=1, opposite="deployment")
Deployment.deployedArtifact = association("deployedArtifact", DeployedArtifact, opposite="deployment")
Dependency.client.add(Deployment.location)  # type: ignore[attr-defined]
Element.owner.add(Deployment.location)  # type: ignore[attr-defined]
Dependency.supplier.add(Deployment.deployedArtifact)  # type: ignore[attr-defined]
ActivityPartition.node = association("node", ActivityNode, opposite="inPartition")
ActivityPartition.subpartition = association("subpartition", ActivityPartition)
ActivityPartition.represents = association("represents", Element, upper=1)
ActivityGroup.subgroup.add(ActivityPartition.subpartition)  # type: ignore[attr-defined]
AcceptEventAction.result = association("result", OutputPin, composite=True)
ReplyAction.replyValue = association("replyValue", InputPin, upper=1, composite=True)
ReplyAction.returnInformation = association("returnInformation", InputPin, upper=1, composite=True)
UnmarshallAction.result = association("result", OutputPin, composite=True)
UnmarshallAction.unmarshallType = association("unmarshallType", Classifier, upper=1)
UnmarshallAction.object = association("object", InputPin, upper=1, composite=True)
AcceptCallAction.returnInformation = association("returnInformation", OutputPin, upper=1, composite=True)
InvocationAction.argument = association("argument", InputPin, composite=True)
SendSignalAction.target = association("target", InputPin, composite=True)
Collaboration.collaborationRole = association("collaborationRole", ConnectableElement)
StructuredClassifier.role.add(Collaboration.collaborationRole)  # type: ignore[attr-defined]
Trigger.event = association("event", Event, upper=1)
Trigger.port = association("port", Port)
# 91: override ExecutionSpecification.finish(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.finish = derived('finish', OccurrenceSpecification, 0, 1,
    lambda obj: [eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 1])

# 87: override ExecutionSpecification.start(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.start = derived('start', OccurrenceSpecification, 0, 1,
    lambda obj: [eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 0])

ExecutionSpecification.executionOccurrenceSpecification = association("executionOccurrenceSpecification", ExecutionOccurrenceSpecification, upper=2, composite=True, opposite="execution")
ExecutionOccurrenceSpecification.execution = association("execution", ExecutionSpecification, upper=1, opposite="executionOccurrenceSpecification")
ActionExecutionSpecification.action = association("action", Action, upper=1)
BehaviorExecutionSpecification.behavior = association("behavior", Behavior, upper=1)
ChangeEvent.changeExpression = association("changeExpression", ValueSpecification, upper=1, composite=True, opposite="changeEvent")
ParameterSet.parameter = association("parameter", Parameter, lower=1, opposite="parameterSet")
ParameterSet.condition = association("condition", Constraint, composite=True, opposite="parameterSet")
ParameterSet.behavioralFeature = association("behavioralFeature", BehavioralFeature, upper=1, opposite="ownedParameterSet")
ParameterSet.behavior = association("behavior", Behavior, upper=1, opposite="ownedParameterSet")
Element.ownedElement.add(ParameterSet.condition)  # type: ignore[attr-defined]
NamedElement.namespace.add(ParameterSet.behavioralFeature)  # type: ignore[attr-defined]
NamedElement.namespace.add(ParameterSet.behavior)  # type: ignore[attr-defined]
ComponentRealization.abstraction = association("abstraction", Component, upper=1, opposite="realization")
ComponentRealization.realizingClassifier = association("realizingClassifier", Classifier, upper=1, opposite="componentRealization")
Dependency.supplier.add(ComponentRealization.abstraction)  # type: ignore[attr-defined]
Element.owner.add(ComponentRealization.abstraction)  # type: ignore[attr-defined]
Dependency.client.add(ComponentRealization.realizingClassifier)  # type: ignore[attr-defined]
InformationItem.represented = association("represented", Classifier)
InformationFlow.realizingActivityEdge = association("realizingActivityEdge", ActivityEdge)
InformationFlow.realizingMessage = association("realizingMessage", Message)
InformationFlow.informationSource = association("informationSource", NamedElement, upper=1)
InformationFlow.realizingConnector = association("realizingConnector", Connector, upper=1, opposite="informationFlow")
InformationFlow.informationTarget = association("informationTarget", NamedElement, upper=1)
InformationFlow.conveyed = association("conveyed", Classifier, lower=1)
InformationFlow.realization = association("realization", Relationship, opposite="abstraction")
DirectedRelationship.source.add(InformationFlow.informationSource)  # type: ignore[attr-defined]
Element.owner.add(InformationFlow.realizingConnector)  # type: ignore[attr-defined]
DirectedRelationship.target.add(InformationFlow.informationTarget)  # type: ignore[attr-defined]
CallAction.result = association("result", OutputPin, composite=True)
CallBehaviorAction.behavior = association("behavior", Behavior, upper=1)
ValueSpecificationAction.result = association("result", OutputPin, upper=1, composite=True)
ValueSpecificationAction.value = association("value", ValueSpecification, upper=1, composite=True, opposite="valueSpecificationAction")
Element.ownedElement.add(ValueSpecificationAction.value)  # type: ignore[attr-defined]
Comment.annotatedElement = association("annotatedElement", Element, opposite="comment")
Diagram.element = association("element", Element, upper=1, opposite="ownedDiagram")
Element.owner.add(Diagram.element)  # type: ignore[attr-defined]
