/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.windows8;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

final class DPIUnscaledBorder
implements Border,
UIResource {
    private final Border delegate;
    private final boolean tabContainer;

    public DPIUnscaledBorder(Border delegate, boolean tabContainer) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.tabContainer = tabContainer;
    }

    public DPIUnscaledBorder(Border delegate) {
        this(delegate, false);
    }

    @Override
    public void paintBorder(Component c, Graphics g0, int x, int y, int width, int height) {
        int deviceHeight;
        int deviceWidth;
        Graphics2D g = (Graphics2D)g0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        AffineTransform tx = g.getTransform();
        int txType = tx.getType();
        if (txType == 2 || txType == 3) {
            int deviceY;
            int deviceX;
            double scale = tx.getScaleX();
            if (this.tabContainer) {
                deviceX = (int)Math.round(tx.getTranslateX());
                deviceY = (int)Math.floor(tx.getTranslateY());
            } else if (scale == 1.5 && c instanceof JTextField) {
                deviceX = (int)Math.floor(tx.getTranslateX());
                deviceY = (int)Math.floor(tx.getTranslateY());
            } else {
                deviceX = (int)Math.round(tx.getTranslateX());
                deviceY = (int)Math.round(tx.getTranslateY());
            }
            int deviceXend = (int)Math.floor(tx.getTranslateX() + (double)width * scale);
            int deviceYend = (int)Math.floor(tx.getTranslateY() + (double)height * scale);
            deviceWidth = deviceXend - deviceX;
            deviceHeight = deviceYend - deviceY;
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, deviceX, deviceY));
        } else {
            deviceWidth = width;
            deviceHeight = height;
        }
        this.delegate.paintBorder(c, g, 0, 0, deviceWidth, deviceHeight);
        g.setTransform(oldTransform);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.delegate.getBorderInsets(c);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

