/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.Color;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.gephi.branding.desktop.DragNDropFrameAdapter;
import org.gephi.branding.desktop.MemoryStarvationManager;
import org.gephi.branding.desktop.ProjectOpenFilesHandler;
import org.gephi.branding.desktop.reporter.ReporterHandler;
import org.gephi.ui.utils.UIUtils;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final String LATEST_GEPHI_VERSION_URL = "https://raw.githubusercontent.com/gephi/gephi/gh-pages/latest";

    protected static boolean isNewVersion(String latest, String current) {
        String gephiVersionTst = current.replaceAll("[0-9]{12}", "").replaceAll("[a-zA-Z -]", "");
        latest = latest.replaceAll("[a-zA-Z -]", "");
        int res = ModuleDescriptor.Version.parse(gephiVersionTst).compareTo(ModuleDescriptor.Version.parse(latest));
        return res < 0;
    }

    public void restored() {
        this.initGephi();
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        if (UIUtils.isAquaLookAndFeel()) {
            UIManager.put("TabbedPane.foreground", Color.BLACK);
        }
        if (System.getProperty("org.gephi.crashReporter.enabled", "true").equals("true")) {
            Logger.getLogger("").addHandler(new ReporterHandler());
        }
        if (System.getProperty("org.gephiMemoryStarvationManager.enabled", "true").equals("true")) {
            MemoryStarvationManager memoryStarvationManager = new MemoryStarvationManager();
            memoryStarvationManager.startup();
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        Installer.this.checkForNewMajorRelease();
                    }
                }.start();
            }
        });
        this.installOutputLogger();
    }

    private void initGephi() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                DragNDropFrameAdapter.register();
            }
        });
        if (Utilities.isMac()) {
            try {
                Desktop.getDesktop().setOpenFileHandler(new ProjectOpenFilesHandler());
            }
            catch (Exception e) {
                Logger.getLogger(Installer.class.getName()).log(Level.WARNING, "Can't setup OpenFilesHandler", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNewMajorRelease() {
        boolean doCheck = NbPreferences.forModule(Installer.class).getBoolean("check_latest_version", true);
        if (doCheck) {
            InputStream stream = null;
            BufferedReader reader = null;
            try {
                String gephiVersion = System.getProperty("netbeans.productversion");
                if (gephiVersion.contains("SNAPSHOT")) {
                    return;
                }
                URL url = new URL(LATEST_GEPHI_VERSION_URL);
                URLConnection connection = url.openConnection();
                connection.setRequestProperty("User-Agent", "");
                connection.connect();
                stream = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                String latest = reader.readLine();
                if (Installer.isNewVersion(latest, gephiVersion)) {
                    JCheckBox checkbox = new JCheckBox(NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.dontShowAgain"), false);
                    String message = NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.message", (Object)latest, (Object)gephiVersion);
                    int option = JOptionPane.showConfirmDialog(null, new Object[]{message, checkbox}, NbBundle.getMessage(Installer.class, (String)"MajorReleaseCheck.newVersion"), 2, 1);
                    NbPreferences.forModule(Installer.class).putBoolean("check_latest_version", !checkbox.isSelected());
                    if (option == 0) {
                        Desktop.getDesktop().browse(new URI("http://gephi.org/users/download/"));
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger("").warning("Error while checking latest Gephi version");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void installOutputLogger() {
        Logger.getLogger("").addHandler(new OutputHandler());
    }

    private static class OutputHandler
    extends Handler {
        private final InputOutput io = IOProvider.getDefault().getIO("Log", true);
        private final OutputWriter outputWriter = this.io.getOut();
        private final MsgFormatter formatter = new MsgFormatter();

        @Override
        public void publish(LogRecord record) {
            if ((record.getMessage() == null || record.getMessage().isEmpty()) && record.getThrown() == null) {
                return;
            }
            Color color = Color.BLACK;
            if (record.getLevel().equals(Level.WARNING)) {
                color = Color.ORANGE;
            } else if (record.getLevel().equals(Level.SEVERE)) {
                color = Color.RED;
            }
            String msg = this.formatter.format(record);
            if (IOColorLines.isSupported((InputOutput)this.io)) {
                try {
                    IOColorLines.println((InputOutput)this.io, (CharSequence)msg, (Color)color);
                }
                catch (IOException ex) {
                    this.outputWriter.println(msg);
                }
            } else {
                this.outputWriter.println(msg);
            }
        }

        @Override
        public void flush() {
            this.outputWriter.flush();
        }

        @Override
        public void close() throws SecurityException {
            this.outputWriter.close();
        }

        public class MsgFormatter
        extends Formatter {
            @Override
            public synchronized String format(LogRecord record) {
                String formattedMessage = this.formatMessage(record);
                String throwable = "";
                String outputFormat = "[%1$s] %2$s %3$s";
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println();
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    throwable = sw.toString();
                }
                return String.format(outputFormat, record.getLevel().getName(), formattedMessage, throwable);
            }
        }
    }
}

