/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.util.NbBundle;

public class TabTable
extends JTable {
    private int tabsLocation = 1;
    private final int orientation;
    private final TabDataRenderer renderer = new TabDataRenderer();
    private int closeButtonRow = -1;
    private int closeButtonCol = -1;

    public TabTable(TabDataModel tabModel, int tabsLocation) {
        this(TabTableModel.create(tabModel, tabsLocation), tabsLocation == 1 || tabsLocation == 3 ? 0 : 1);
        this.tabsLocation = tabsLocation;
    }

    protected TabTable(TabTableModel tableModel, int orientation) {
        super(tableModel);
        this.orientation = orientation;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() != -1) {
                    TabTable.this.adjustColumnWidths();
                }
            }
        });
        this.configure();
    }

    private void configure() {
        boolean show;
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setTableHeader(null);
        this.setSelectionMode(0);
        this.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setOpaque(false);
        this.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setDefaultRenderer(Object.class, this.renderer);
        Object showVerticalLines = UIManager.get("nb.multitabs.showVerticalLines");
        Object showHorizontalLines = UIManager.get("nb.multitabs.showHorizontalLines");
        if (showVerticalLines instanceof Boolean) {
            show = (Boolean)showVerticalLines != false && this.orientation == 0;
            this.setShowVerticalLines(show);
            this.setIntercellSpacing(new Dimension(show ? 1 : 0, this.getIntercellSpacing().height));
        }
        if (showHorizontalLines instanceof Boolean) {
            show = (Boolean)showHorizontalLines != false && this.orientation != 0;
            this.setShowHorizontalLines(show);
            this.setIntercellSpacing(new Dimension(this.getIntercellSpacing().width, show ? 1 : 0));
        }
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setRowHeight(TabDataRenderer.getPreferredTableRowHeight());
    }

    int getTabsLocation() {
        return this.tabsLocation;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.orientation == 0 ? true : super.getScrollableTracksViewportHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.orientation == 0 ? super.getScrollableTracksViewportHeight() : true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int res = 0;
        if (orientation == 1) {
            res = this.getRowHeight() / 2;
        } else {
            Point columnPoint = visibleRect.getLocation();
            ++columnPoint.x;
            int col = this.columnAtPoint(columnPoint);
            if (col >= 0) {
                Rectangle rect = this.getCellRect(0, col, true);
                res = rect.width / 2;
            } else {
                res = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        }
        if (direction < 0) {
            res *= -1;
        }
        return res;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int col = this.columnAtPoint(event.getPoint());
        if (row >= 0 && col >= 0) {
            if (this.isCloseButtonHighlighted(row, col)) {
                return NbBundle.getMessage(TabTable.class, (String)"BtnClose_Tooltip");
            }
            TabData td = (TabData)this.getValueAt(row, col);
            if (null != td) {
                return td.getTooltip();
            }
        }
        return super.getToolTipText(event);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.adjustColumnWidths();
    }

    protected void adjustColumnWidths() {
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn tc = colModel.getColumn(i);
            int colWidth = 0;
            for (int row = 0; row < this.getRowCount(); ++row) {
                colWidth = Math.max(this.renderer.getPreferredWidth(this.getValueAt(row, i)), colWidth);
            }
            colWidth = Math.max(colWidth, 30);
            tc.setWidth(colWidth += this.getIntercellSpacing().width);
            tc.setMinWidth(colWidth);
            tc.setMaxWidth(colWidth);
            tc.setPreferredWidth(colWidth);
            tc.setResizable(false);
        }
    }

    TabData getTabAt(Point p) {
        if (p.x < 0 || p.y < 0) {
            return null;
        }
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (row < 0 || col < 0) {
            return null;
        }
        return (TabData)this.getValueAt(row, col);
    }

    void setCurrentCloseButtonCoords(int closeButtonRow, int closeButtonColumn) {
        int oldRow = this.closeButtonRow;
        int oldCol = this.closeButtonCol;
        boolean change = closeButtonRow != this.closeButtonRow || closeButtonColumn != this.closeButtonCol;
        this.closeButtonCol = closeButtonColumn;
        this.closeButtonRow = closeButtonRow;
        if (change) {
            Rectangle rect;
            if (oldRow >= 0 && oldCol >= 0 && null != (rect = this.getCellRect(oldRow, oldCol, true))) {
                this.repaint(rect);
            }
            if (this.closeButtonRow >= 0 && this.closeButtonCol >= 0 && null != (rect = this.getCellRect(this.closeButtonRow, this.closeButtonCol, true))) {
                this.repaint(rect);
            }
        }
    }

    boolean isCloseButtonHighlighted(int row, int col) {
        return row == this.closeButtonRow && this.closeButtonCol == col;
    }

    Rectangle getTabBounds(int tabIndex) {
        TabTableModel tabModel = (TabTableModel)this.getModel();
        int col = tabModel.toColumnIndex(tabIndex);
        int row = tabModel.toRowIndex(tabIndex);
        if (row >= 0 && col >= 0) {
            col = this.convertColumnIndexToView(col);
            row = this.convertRowIndexToView(row);
            return this.getCellRect(row, col, true);
        }
        return null;
    }

    @Override
    public void setUI(TableUI ui) {
        super.setUI(new TabTableUI());
    }
}

