/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLExtImpl;
import jogamp.opengl.windows.wgl.WGLExtProcAddressTable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;

public class WindowsWGLContext
extends GLContextImpl {
    static final Map<String, String> extensionNameMap = new HashMap<String, String>();
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private boolean wglGLReadDrawableAvailableSet;
    private boolean wglGLReadDrawableAvailable;
    private WGLExt _wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;
    private int hasSwapInterval = 0;
    private int hasSwapGroupNV = 0;

    WindowsWGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates(boolean bl) {
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglGLReadDrawableAvailableSet = false;
        this.wglGLReadDrawableAvailable = false;
        this.wglExtProcAddressTable = null;
        this.hasSwapInterval = 0;
        this.hasSwapGroupNV = 0;
        super.resetStates(bl);
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    final WGLExt getWGLExt() {
        if (null == this.getWGLExtProcAddressTable()) {
            throw new InternalError("Null WGLExtProcAddressTable");
        }
        if (this._wglExt == null) {
            this._wglExt = new WGLExtImpl(this);
        }
        return this._wglExt;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        if (!this.wglGLReadDrawableAvailableSet && null != this.getWGLExtProcAddressTable()) {
            WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            switch (windowsWGLDrawableFactory.isReadDrawableAvailable(abstractGraphicsDevice)) {
                case 1: {
                    this.wglGLReadDrawableAvailable = true;
                    this.wglGLReadDrawableAvailableSet = true;
                    break;
                }
                case 0: {
                    this.wglGLReadDrawableAvailable = false;
                    this.wglGLReadDrawableAvailableSet = true;
                }
            }
        }
        return this.wglGLReadDrawableAvailable;
    }

    private final boolean wglMakeContextCurrent(long l, long l2, long l3) {
        boolean bl = false;
        if (this.wglGLReadDrawableAvailable) {
            bl = this.getWGLExt().wglMakeContextCurrent(l, l2, l3);
        } else if (l == l2) {
            bl = WGL.wglMakeCurrent(l, l3);
        } else {
            throw new InternalError("Given readDrawable but no driver support");
        }
        if (DEBUG && !bl) {
            Throwable throwable = new Throwable("Info: wglMakeContextCurrent NOK: draw " + GLContext.toHexString(l) + ", read " + GLContext.toHexString(l2) + ", ctx " + GLContext.toHexString(l3) + ", werr " + GDI.GetLastError());
            throwable.printStackTrace();
        }
        return bl;
    }

    private final boolean wglReleaseContext() {
        boolean bl = false;
        bl = this.wglGLReadDrawableAvailable ? this.getWGLExt().wglMakeContextCurrent(0L, 0L, 0L) : WGL.wglMakeCurrent(0L, 0L);
        if (!bl) {
            boolean bl2;
            int n = GDI.GetLastError();
            boolean bl3 = bl2 = n == 0;
            if (DEBUG) {
                Throwable throwable = new Throwable("Info: wglReleaseContext NOK: werr " + n + " -> ok " + bl2);
                throwable.printStackTrace();
            }
            return bl2;
        }
        return bl;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getWGLExtProcAddressTable();
    }

    public final WGLExtProcAddressTable getWGLExtProcAddressTable() {
        return this.wglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return extensionNameMap;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        WGL.wglMakeCurrent(0L, 0L);
        WGL.wglDeleteContext(l);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        block20: {
            Object object;
            boolean bl2;
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + " - WindowWGLContext.createContextARBImpl: " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", share " + WindowsWGLContext.toHexString(l) + ", direct " + bl);
            }
            boolean bl3 = 0 == (8 & n);
            boolean bl4 = 0 != (2 & n);
            boolean bl5 = 0 != (0x10 & n);
            boolean bl6 = bl2 = 0 != (0x20 & n);
            if (!bl3) {
                if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": WindowWGLContext.createContextARBImpl: GL ES not avail " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                return 0L;
            }
            if (null == this.getWGLExtProcAddressTable()) {
                object = this.getGLDynamicLookupHelper(n2, n);
                if (null == object) {
                    if (DEBUG) {
                        System.err.println(WindowsWGLContext.getThreadName() + " - WindowWGLContext.createContextARBImpl: Null GLDynamicLookupHelper");
                    }
                    return 0L;
                }
                this.updateGLXProcAddressTable(null, (GLDynamicLookupHelper)((Object)object));
            }
            object = this.getWGLExt();
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + " - WindowWGLContext.createContextARBImpl: , wglCreateContextAttribsARB: " + WindowsWGLContext.toHexString(this.wglExtProcAddressTable._addressof_wglCreateContextAttribsARB));
            }
            l2 = 0L;
            int[] nArray = new int[]{8337, n2, 8338, n3, 8340, 0, 0, 0, 0};
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                nArray[6] = 37158;
                nArray[7] = bl4 ? 2 : 1;
            }
            if (n2 >= 3) {
                if (!bl4 && bl5) {
                    nArray[5] = nArray[5] | 2;
                }
                if (bl2) {
                    nArray[5] = nArray[5] | 1;
                }
            }
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])nArray);
                l2 = object.wglCreateContextAttribsARB(this.drawable.getHandle(), l, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block20;
                Throwable throwable = new Throwable("Info: WindowWGLContext.createContextARBImpl wglCreateContextAttribsARB failed with " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"), runtimeException);
                throwable.printStackTrace();
            }
        }
        if (0L != l2) {
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                if (DEBUG) {
                    System.err.println("WindowsWGLContext.createContextARB couldn't make current " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: OK " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: NO " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l2;
    }

    @Override
    protected boolean createImpl(long l) throws GLException {
        long l2;
        GLProfile gLProfile;
        boolean bl;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
        WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsWGLDrawableFactory.getOrCreateSharedContext(abstractGraphicsDevice);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = this.drawable.getChosenGLCapabilities();
        this.isGLReadDrawableAvailable();
        boolean bl2 = this.isCreateContextARBAvail(abstractGraphicsDevice) && !gLCapabilitiesImmutable.isBitmap();
        boolean bl3 = bl = null != windowsWGLContext && windowsWGLContext.isCreatedWithARBMethod();
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": WindowsWGLContext.createImpl: START " + gLCapabilitiesImmutable + ", share " + WindowsWGLContext.toHexString(l));
            System.err.println(WindowsWGLContext.getThreadName() + ": Use ARB[avail[" + this.getCreateContextARBAvailStr(abstractGraphicsDevice) + "], bitmap " + gLCapabilitiesImmutable.isBitmap() + " -> " + bl2 + "], shared " + bl + "]");
        }
        if ((gLProfile = gLCapabilitiesImmutable.getGLProfile()).isGLES()) {
            throw new GLException(WindowsWGLContext.getThreadName() + ": Unable to create OpenGL ES context on desktopDevice " + abstractGraphicsDevice + ", config " + abstractGraphicsConfiguration + ", " + gLProfile + ", shareWith " + WindowsWGLContext.toHexString(l));
        }
        boolean bl4 = false;
        if (bl2 && bl) {
            if (windowsWGLContext.getRendererQuirks().exist(10)) {
                if (0 == windowsWGLContext.makeCurrent()) {
                    throw new GLException("Could not make Shared Context current: " + windowsWGLContext);
                }
                this.contextHandle = this.createContextARB(l, true);
                windowsWGLContext.release();
                if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
                }
            } else {
                this.contextHandle = this.createContextARB(l, true);
            }
            bl4 = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (ARB, using sharedContext) share " + WindowsWGLContext.toHexString(l));
            }
        }
        if (0L == this.contextHandle) {
            l2 = WGL.wglCreateContext(this.drawable.getHandle());
            if (0L == l2) {
                throw new GLException("Unable to create temp OpenGL context for device context " + WindowsWGLContext.toHexString(this.drawable.getHandle()));
            }
            if (!WGL.wglMakeCurrent(this.drawable.getHandle(), l2)) {
                throw new GLException("Error making temp context current: 0x" + WindowsWGLContext.toHexString(l2) + ", werr: " + GDI.GetLastError());
            }
            if (!this.setGLFunctionAvailability(true, 0, 0, 0, false, null == windowsWGLContext)) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                throw new GLException("setGLFunctionAvailability !strictMatch failed");
            }
            WGL.wglMakeCurrent(0L, 0L);
            if (bl2 && !bl4) {
                boolean bl5 = this.isFunctionAvailable("wglCreateContextAttribsARB");
                boolean bl6 = this.isExtensionAvailable("WGL_ARB_create_context");
                if (bl5 && bl6) {
                    this.contextHandle = this.createContextARB(l, true);
                    bl4 = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (ARB, initial) share " + WindowsWGLContext.toHexString(l));
                        } else {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - creation failed - share " + WindowsWGLContext.toHexString(l));
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - extension not available - share " + WindowsWGLContext.toHexString(l) + ", isProcCreateContextAttribsARBAvailable " + bl5 + ", isExtGLXARBCreateContextAvailable " + bl6);
                }
            }
        } else {
            l2 = 0L;
        }
        if (0L != this.contextHandle) {
            l = 0L;
            if (0L != l2) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
                }
            }
        } else {
            if (gLCapabilitiesImmutable.getGLProfile().isGL3() && bl4) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                throw new GLException(WindowsWGLContext.getThreadName() + ": createImpl ctx !ARB but ARB is used, profile > GL2 requested (OpenGL >= 3.1). Requested: " + gLCapabilitiesImmutable.getGLProfile() + ", current: " + this.getGLVersion());
            }
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl ARB not used[avail " + bl2 + ", tried " + bl4 + "], fall back to !ARB context " + this.getGLVersion());
            }
            this.contextHandle = l2;
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(this.contextHandle);
                throw new GLException("Error making old context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
            }
            if (0L != l && !WGL.wglShareLists(l, this.contextHandle)) {
                throw new GLException("wglShareLists(" + WindowsWGLContext.toHexString(l) + ", " + WindowsWGLContext.toHexString(this.contextHandle) + ") failed: werr " + GDI.GetLastError());
            }
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (old) share " + WindowsWGLContext.toHexString(l));
            }
        }
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + WindowsWGLContext.toHexString(this.contextHandle) + " current on Thread " + WindowsWGLContext.getThreadName() + ", drawableWrite " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + WindowsWGLContext.toHexString(this.drawableRead.getHandle()) + ", werr: " + GDI.GetLastError() + ", " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.wglReleaseContext()) {
            throw new GLException("Error freeing OpenGL context, werr: " + GDI.GetLastError());
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        WGL.wglMakeCurrent(0L, 0L);
        if (!WGL.wglDeleteContext(this.contextHandle)) {
            throw new GLException("Unable to delete OpenGL context");
        }
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (!WGL.wglCopyContext(gLContext.getHandle(), this.getHandle(), n)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable(String string, GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (null == gLDynamicLookupHelper) {
            throw new GLException("No GLDynamicLookupHelper for " + this);
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string2 = "WGL-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": Initializing WGL extension address table: " + string2);
        }
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglGLReadDrawableAvailableSet = false;
        this.wglGLReadDrawableAvailable = false;
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string2);
        }
        if (null != procAddressTable) {
            this.wglExtProcAddressTable = (WGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": GLContext WGL ProcAddressTable reusing key(" + string2 + ") -> " + WindowsWGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.wglExtProcAddressTable = new WGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.wglExtProcAddressTable, gLDynamicLookupHelper);
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string2, this.getWGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": GLContext WGL ProcAddressTable mapping key(" + string2 + ") -> " + WindowsWGLContext.toHexString(((Object)((Object)this.getWGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            stringBuilder.append(this.getWGLExt().wglGetExtensionsStringEXT());
        }
        return stringBuilder;
    }

    @Override
    protected final Integer setSwapIntervalImpl2(int n) {
        block16: {
            block15: {
                if (!this.drawable.getChosenGLCapabilities().isOnscreen()) {
                    return null;
                }
                if (0 == this.hasSwapInterval) {
                    try {
                        if (this.isExtensionAvailable("WGL_EXT_swap_control")) {
                            this.hasSwapInterval = 1;
                            if (this.isExtensionAvailable("WGL_EXT_swap_control_tear")) {
                                this.hasSwapInterval = 2;
                                if (DEBUG) {
                                    System.err.println("WGLContext.setSwapInterval.2 using: WGL_EXT_swap_control_tear, WGL_EXT_swap_control_tear");
                                }
                            } else {
                                this.hasSwapInterval = 1;
                                if (DEBUG) {
                                    System.err.println("WGLContext.setSwapInterval.1 using: WGL_EXT_swap_control");
                                }
                            }
                        } else {
                            this.hasSwapInterval = -1;
                            if (DEBUG) {
                                System.err.println("WGLContext.setSwapInterval.0 N/A");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.hasSwapInterval = -1;
                        if (!DEBUG) break block15;
                        ExceptionUtils.dumpThrowable((String)"", (Throwable)throwable);
                    }
                }
            }
            if (0 < this.hasSwapInterval) {
                int n2 = 1 == this.hasSwapInterval && 0 > n ? Math.abs(n) : n;
                try {
                    WGLExt wGLExt = this.getWGLExt();
                    if (wGLExt.wglSwapIntervalEXT(n2)) {
                        return n2;
                    }
                }
                catch (Throwable throwable) {
                    this.hasSwapInterval = -1;
                    if (!DEBUG) break block16;
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)throwable);
                }
            }
        }
        return null;
    }

    private final int initSwapGroupImpl(WGLExt wGLExt) {
        if (0 == this.hasSwapGroupNV) {
            try {
                this.hasSwapGroupNV = wGLExt.isExtensionAvailable("WGL_NV_swap_group") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = 1;
            }
            if (DEBUG) {
                System.err.println("initSwapGroupImpl: hasSwapGroupNV: " + this.hasSwapGroupNV);
            }
        }
        return this.hasSwapGroupNV;
    }

    @Override
    protected final boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)(nArray.length - n));
                IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)(nArray2.length - n2));
                if (wGLExt.wglQueryMaxSwapGroupsNV(nativeSurface.getDisplayHandle(), intBuffer, intBuffer2)) {
                    intBuffer.get(nArray, n, intBuffer.remaining());
                    intBuffer2.get(nArray, n, intBuffer2.remaining());
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean joinSwapGroupImpl(int n) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            try {
                if (wGLExt.wglJoinSwapGroupNV(this.drawable.getHandle(), n)) {
                    this.currentSwapGroup = n;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean bindSwapBarrierImpl(int n, int n2) {
        boolean bl = false;
        WGLExt wGLExt = this.getWGLExt();
        if (this.initSwapGroupImpl(wGLExt) > 0) {
            try {
                if (wGLExt.wglBindSwapBarrierNV(n, n2)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    static {
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

