/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.features.bsim.gui.BSimServerManager;
import ghidra.features.bsim.gui.search.dialog.BSimServerManagerListener;
import ghidra.features.bsim.gui.search.dialog.ConnectionPoolStatus;
import ghidra.features.bsim.query.BSimPostgresDBConnectionManager;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;

public class BSimServerTableModel
extends GDynamicColumnTableModel<BSimServerInfo, Object> {
    private List<BSimServerInfo> servers;
    private Map<BSimServerInfo, ConnectionPoolStatus> statusCache = new HashMap<BSimServerInfo, ConnectionPoolStatus>();
    private BSimServerManager serverManager;
    private BSimServerManagerListener listener = new BSimServerManagerListener(){

        @Override
        public void serverListChanged() {
            BSimServerTableModel.this.updateServers();
        }
    };

    public BSimServerTableModel(BSimServerManager serverManager) {
        super((ServiceProvider)new ServiceProviderStub());
        this.serverManager = serverManager;
        serverManager.addListener(this.listener);
        this.servers = new ArrayList<BSimServerInfo>(serverManager.getServerInfos());
    }

    public String getName() {
        return "BSim Servers";
    }

    public List<BSimServerInfo> getModelData() {
        return this.servers;
    }

    public void fireTableDataChanged() {
        this.statusCache.clear();
        super.fireTableDataChanged();
    }

    ConnectionPoolStatus getConnectionPoolStatus(BSimServerInfo serverInfo) {
        return this.statusCache.computeIfAbsent(serverInfo, s -> new ConnectionPoolStatus((BSimServerInfo)s));
    }

    protected TableColumnDescriptor<BSimServerInfo> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new DatabaseNameColumn(this), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new HostColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PortColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new UserInfoColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ConnectionStatusColumn());
        return descriptor;
    }

    public Object getDataSource() {
        return null;
    }

    private void updateServers() {
        this.servers = new ArrayList<BSimServerInfo>(this.serverManager.getServerInfos());
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.serverManager.removeListener(this.listener);
        super.dispose();
    }

    private class DatabaseNameColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, String, Object> {
        private GColumnRenderer<String> renderer = new AbstractGColumnRenderer<String>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                BSimServerInfo info = (BSimServerInfo)data.getRowObject();
                if (info.getDBType() == BSimServerInfo.DBType.file) {
                    label.setToolTipText(info.getDBName());
                } else {
                    label.setToolTipText("");
                }
                return label;
            }

            public String getFilterString(String value, Settings settings) {
                return value;
            }
        };

        private DatabaseNameColumn(BSimServerTableModel bSimServerTableModel) {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getShortDBName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private static class TypeColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, String, Object> {
        private TypeColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getDBType().toString();
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private static class HostColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, String, Object> {
        private HostColumn() {
        }

        public String getColumnName() {
            return "Host";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return serverInfo.getServerName();
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private static class PortColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, String, Object> {
        private PortColumn() {
        }

        public String getColumnName() {
            return "Port";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            int port = serverInfo.getPort();
            if (port <= 0) {
                return null;
            }
            return Integer.toString(port);
        }

        public int getColumnPreferredWidth() {
            return 60;
        }
    }

    private static class UserInfoColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, String, Object> {
        private UserInfoColumn() {
        }

        public String getColumnName() {
            return "User";
        }

        public String getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            if (serverInfo.hasDefaultLogin()) {
                BSimPostgresDBConnectionManager.BSimPostgresDataSource ds;
                if (serverInfo.getDBType() == BSimServerInfo.DBType.postgres && (ds = BSimPostgresDBConnectionManager.getDataSourceIfExists(serverInfo)) != null) {
                    return ds.getUserName();
                }
                return "";
            }
            Object info = serverInfo.getUserName();
            boolean hasPassword = serverInfo.hasPassword();
            if (hasPassword) {
                info = (String)info + ":****";
            }
            return info;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class ConnectionStatusColumn
    extends AbstractDynamicTableColumn<BSimServerInfo, ConnectionPoolStatus, Object> {
        private ConnectionStatusColumn() {
        }

        public String getColumnName() {
            return "Active/Idle Connections";
        }

        public ConnectionPoolStatus getValue(BSimServerInfo serverInfo, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return BSimServerTableModel.this.getConnectionPoolStatus(serverInfo);
        }

        public int getColumnPreferredWidth() {
            return 150;
        }

        public GColumnRenderer<ConnectionPoolStatus> getColumnRenderer() {
            return ConnectionStatusColumnRenderer.INSTANCE;
        }
    }

    private static class ConnectionStatusColumnRenderer
    extends AbstractGColumnRenderer<ConnectionPoolStatus> {
        private static final ConnectionStatusColumnRenderer INSTANCE = new ConnectionStatusColumnRenderer();

        private ConnectionStatusColumnRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(data);
            ConnectionPoolStatus status = (ConnectionPoolStatus)data.getValue();
            Icon icon = null;
            String text = null;
            if (status.isActive) {
                text = Integer.toString(status.activeCount) + " / " + Integer.toString(status.idleCount);
            }
            c.setText(text);
            c.setIcon(icon);
            return c;
        }

        public String getFilterString(ConnectionPoolStatus t, Settings settings) {
            return null;
        }
    }
}

