/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class CallgraphEntry
implements Comparable<CallgraphEntry> {
    private FunctionDescription dest;
    private int lochash;

    public CallgraphEntry(FunctionDescription d, int lhash) {
        this.dest = d;
        this.lochash = lhash;
    }

    public FunctionDescription getFunctionDescription() {
        return this.dest;
    }

    public int getLocalHash() {
        return this.lochash;
    }

    public void saveXml(FunctionDescription src, Writer fwrite) throws IOException {
        ExecutableRecord destexe;
        ExecutableRecord srcexe;
        StringBuilder buf = new StringBuilder();
        buf.append("<call");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"dest", (String)this.dest.getFunctionName());
        if (this.dest.getAddress() != -1L) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"addr", (long)this.dest.getAddress());
        }
        if (this.lochash != 0) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"local", (long)this.lochash);
        }
        if ((srcexe = src.getExecutableRecord()) != (destexe = this.dest.getExecutableRecord())) {
            buf.append(">\n");
            if (!destexe.isLibrary()) {
                buf.append("  <md5>").append(destexe.getMd5()).append("</md5>\n");
            }
            buf.append("  <name>");
            SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)destexe.getNameExec());
            buf.append("</name>\n");
            if (!srcexe.getArchitecture().equals(destexe.getArchitecture())) {
                buf.append("  <arch>");
                SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)destexe.getArchitecture());
                buf.append("</arch>\n");
            }
            if (!srcexe.getNameCompiler().equals(destexe.getNameCompiler())) {
                buf.append("  <compiler>");
                SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)destexe.getNameCompiler());
                buf.append("</compiler>\n");
            }
            buf.append("</call>\n");
        } else {
            buf.append("/>\n");
        }
        fwrite.append(buf.toString());
    }

    public static void restoreXml(XmlPullParser parser, DescriptionManager man, FunctionDescription src) throws LSHException {
        XmlElement el = parser.start(new String[]{"call"});
        String destnm = el.getAttribute("dest");
        long address = -1L;
        String addrString = el.getAttribute("addr");
        if (addrString != null) {
            address = SpecXmlUtils.decodeLong((String)addrString);
        }
        int val = SpecXmlUtils.decodeInt((String)el.getAttribute("local"));
        if (parser.peek().isStart()) {
            ExecutableRecord srcexe = src.getExecutableRecord();
            String md5 = null;
            String dest_enm = null;
            String dest_cnm = srcexe.getNameCompiler();
            String dest_arch = srcexe.getArchitecture();
            do {
                String elname = parser.next().getName();
                String content = parser.end().getText();
                if (elname.equals("md5")) {
                    md5 = content;
                    continue;
                }
                if (elname.equals("name")) {
                    dest_enm = content;
                    continue;
                }
                if (elname.equals("compiler")) {
                    dest_cnm = content;
                    continue;
                }
                if (!elname.equals("arch")) continue;
                dest_arch = content;
            } while (parser.peek().isStart());
            if (md5 == null) {
                destexe = man.newExecutableLibrary(dest_enm, dest_arch, null);
                destfunc = man.newFunctionDescription(destnm, address, destexe);
                man.makeCallgraphLink(src, destfunc, val);
            } else {
                destexe = man.newExecutableRecord(md5, dest_enm, dest_cnm, dest_arch, null, srcexe.getRepository(), srcexe.getPath(), null);
                destfunc = man.newFunctionDescription(destnm, address, destexe);
                man.makeCallgraphLink(src, destfunc, val);
            }
        } else {
            FunctionDescription destfunc = man.newFunctionDescription(destnm, address, src.getExecutableRecord());
            man.makeCallgraphLink(src, destfunc, val);
        }
        parser.end();
    }

    @Override
    public int compareTo(CallgraphEntry o) {
        return this.dest.compareTo(o.dest);
    }
}

