/*
 * Decompiled with CFR 0.152.
 */
package docking;

import ghidra.util.datastruct.FixedSizeStack;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoRedoKeeper {
    private static final int MAX_UNDO_REDO_SIZE = 50;
    private static final String STYLE_EDIT_KEY = "style";
    private FixedSizeStack<UndoableEdit> undoStack = new FixedSizeStack(50);
    private FixedSizeStack<UndoableEdit> redoStack = new FixedSizeStack(50);
    private StyleCompoundEdit lastStyleUndo;

    void addUndo(UndoableEdit edit) {
        String name = edit.getPresentationName();
        if (name.contains(STYLE_EDIT_KEY)) {
            this.addStyleEdit(edit);
            return;
        }
        this.endOutstandingStyleEdits();
        this.undoStack.push((Object)edit);
        this.redoStack.clear();
    }

    private void endOutstandingStyleEdits() {
        if (this.lastStyleUndo != null) {
            this.lastStyleUndo.end();
            this.lastStyleUndo = null;
        }
    }

    private void addStyleEdit(UndoableEdit edit) {
        if (this.lastStyleUndo == null) {
            this.lastStyleUndo = new StyleCompoundEdit();
            this.undoStack.push((Object)this.lastStyleUndo);
        }
        this.lastStyleUndo.addEdit(edit);
        this.redoStack.clear();
    }

    void undo() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        this.endOutstandingStyleEdits();
        UndoableEdit item = (UndoableEdit)this.undoStack.pop();
        this.redoStack.push((Object)item);
        item.undo();
        if (item instanceof StyleCompoundEdit) {
            this.undo();
        }
    }

    void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        this.endOutstandingStyleEdits();
        UndoableEdit item = (UndoableEdit)this.redoStack.pop();
        this.undoStack.push((Object)item);
        item.redo();
        if (item instanceof StyleCompoundEdit) {
            this.undo();
        }
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    private static class StyleCompoundEdit
    extends CompoundEdit {
        private StyleCompoundEdit() {
        }
    }
}

