/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.ErrorListingField;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.awt.event.MouseEvent;

public class ErrorFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{ErrorListingField.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        ErrorListingField errorField = (ErrorListingField)clickedObject;
        String fieldName = errorField.getFieldFactory().getFieldName();
        Msg.showError((Object)this, null, (String)"Listing Field Exception", (Object)("Exception occurred while rendering '" + fieldName + "' field"), (Throwable)errorField.getThrowable());
        return true;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

