/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.AttributedGraph;
import java.io.File;
import java.io.IOException;
import org.jgrapht.Graph;
import org.jgrapht.nio.dimacs.DIMACSExporter;
import org.jgrapht.nio.dimacs.DIMACSFormat;

public class DimacsGraphExporter
extends AbstractAttributedGraphExporter {
    protected DIMACSFormat dimacsFormat = DIMACSExporter.DEFAULT_DIMACS_FORMAT;

    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        DIMACSExporter exporter = new DIMACSExporter(this.vertexIdProvider, this.dimacsFormat);
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "col";
    }

    public String getName() {
        return "DIMACS";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a DIMACS file";
    }
}

