/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import generic.util.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WrappingPeekableIterator<T>
implements PeekableIterator<T> {
    private Iterator<T> iterator;
    private T peek;
    private boolean peeked;

    public WrappingPeekableIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.peeked) {
            return true;
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.peeked) {
            this.peeked = false;
            return this.peek;
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() throws NoSuchElementException {
        if (this.peeked) {
            return this.peek;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.peek = this.next();
        this.peeked = true;
        return this.peek;
    }
}

