/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13InlineeSourceLine;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class C13ExtendedInlineeSourceLine
extends C13InlineeSourceLine {
    private List<Integer> extraFileIds = new ArrayList<Integer>();

    static int getBaseRecordSize() {
        return 16;
    }

    C13ExtendedInlineeSourceLine(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
        super(reader);
        long numExtraFiles = reader.parseUnsignedIntVal();
        for (long i = 0L; i < numExtraFiles; ++i) {
            monitor.checkCancelled();
            this.extraFileIds.add(reader.parseInt());
        }
    }

    public int getNumExtraFileIds() {
        return this.extraFileIds.size();
    }

    public List<Integer> getExtraFileIds() {
        return this.extraFileIds;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("0x%09x, 0x%06x, %d", this.inlinee, this.fileId, this.sourceLineNum));
        for (Integer id : this.extraFileIds) {
            builder.append(String.format(" 0x%06x", id));
        }
        return builder.toString();
    }
}

