/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13ColumnRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.io.IOException;
import java.io.Writer;

public class C13LineRecord {
    private long offset;
    private long bitVals;
    private C13ColumnRecord columnRecord = null;

    public long getOffset() {
        return this.offset;
    }

    public long getLineNumStart() {
        return this.bitVals & 0xFFFFFFL;
    }

    public long getDeltaLineEnd() {
        return this.bitVals >> 24 & 0x7FL;
    }

    public C13ColumnRecord getColumnRecord() {
        return this.columnRecord;
    }

    public boolean isStatement() {
        return (this.bitVals & 0x80000000L) != 0L;
    }

    public boolean isExpression() {
        return !this.isStatement();
    }

    public boolean isSpecialLine() {
        long start = this.getLineNumStart();
        return start == 0xFEEFEEL || start == 0xF00F00L;
    }

    static C13LineRecord parse(PdbByteReader lineReader, PdbByteReader columnReader) throws PdbException {
        return new C13LineRecord(lineReader, columnReader);
    }

    private C13LineRecord(PdbByteReader lineReader, PdbByteReader columnReader) throws PdbException {
        this.offset = lineReader.parseUnsignedIntVal();
        this.bitVals = lineReader.parseUnsignedIntVal();
        if (columnReader != null) {
            this.columnRecord = C13ColumnRecord.parse(columnReader);
        }
    }

    void dump(Writer writer, long offCon) throws IOException {
        String lineStart;
        String string = lineStart = this.isSpecialLine() ? String.format("%06x", this.getLineNumStart()) : String.format("%d", this.getLineNumStart());
        if (this.columnRecord != null) {
            if ((long)this.columnRecord.getOffsetColumnEnd() != 0L) {
                writer.write(String.format("%5d:%5d-%5d-%5d 0x%08x %s", this.getLineNumStart(), this.columnRecord.getOffsetColumnStart(), this.getLineNumStart() + this.getDeltaLineEnd(), this.columnRecord.getOffsetColumnEnd(), this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
            } else {
                writer.write(String.format("%s-%5d 0x%08x %s", lineStart, this.columnRecord.getOffsetColumnStart(), this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
            }
        } else {
            writer.write(String.format("%s 0x%08x %s", lineStart, this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
        }
    }
}

