/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.unix.AbstractEmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixUser;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEmuUnixFileSystem<T>
implements EmuUnixFileSystem<T> {
    protected final Map<String, EmuUnixFile<T>> filesByPath = new HashMap<String, EmuUnixFile<T>>();

    @Override
    public abstract AbstractEmuUnixFile<T> newFile(String var1, int var2) throws EmuIOException;

    @Override
    public synchronized EmuUnixFile<T> createOrGetFile(String pathname, int mode) throws EmuIOException {
        return this.filesByPath.computeIfAbsent(pathname, p -> this.newFile((String)p, mode));
    }

    @Override
    public synchronized EmuUnixFile<T> getFile(String pathname) throws EmuIOException {
        return this.filesByPath.get(pathname);
    }

    @Override
    public synchronized void putFile(String pathname, EmuUnixFile<T> file) throws EmuIOException {
        this.filesByPath.put(pathname, file);
    }

    @Override
    public synchronized EmuUnixFile<T> open(String pathname, Set<EmuUnixFileSystem.OpenFlag> flags, EmuUnixUser user, int mode) throws EmuIOException {
        EmuUnixFile<T> file;
        EmuUnixFile<T> emuUnixFile = file = flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_CREAT) ? this.createOrGetFile(pathname, mode) : this.getFile(pathname);
        if (file == null) {
            throw new EmuIOException("File not found: " + pathname);
        }
        if (flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_RDONLY) || flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_RDWR)) {
            file.checkReadable(user);
        }
        if (flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_WRONLY) || flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_RDWR)) {
            file.checkWritable(user);
            if (flags.contains((Object)EmuUnixFileSystem.OpenFlag.O_TRUNC)) {
                file.truncate();
            }
        }
        return file;
    }

    @Override
    public synchronized void unlink(String pathname, EmuUnixUser user) throws EmuIOException {
        this.filesByPath.remove(pathname);
    }
}

