/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.image;

import ghidra.file.image.GImageFormat;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GImage {
    private int width;
    private int height;
    private int[] array;

    public GImage(int width, int height, GImageFormat format, InputStream data, long dataLength) throws IOException {
        this.width = width;
        this.height = height;
        this.array = this.packDataIntoArray(format, data, dataLength);
    }

    public Icon toPNG() throws IOException {
        ImageWriter imageWriter = this.getImageWriter("png");
        return this.getIcon(imageWriter);
    }

    public Icon toGIF() throws IOException {
        ImageWriter imageWriter = this.getImageWriter("gif");
        return this.getIcon(imageWriter);
    }

    public Icon toJPEG() throws IOException {
        ImageWriter imageWriter = this.getImageWriter("jpeg");
        return this.getIcon(imageWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getIcon(ImageWriter imageWriter) throws IOException {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gDev = gEnv.getDefaultScreenDevice();
        GraphicsConfiguration gConfig = gDev.getDefaultConfiguration();
        BufferedImage bufferedImage = gConfig.createCompatibleImage(this.width, this.height, 3);
        bufferedImage.setRGB(0, 0, this.width, this.height, this.array, 0, this.width);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        imageWriter.setOutput(imageOut);
        try (MemoryCacheImageOutputStream imageOut = new MemoryCacheImageOutputStream(out);){
            imageWriter.write(bufferedImage);
        }
        ImageIcon icon = new ImageIcon(bufferedImage);
        return icon;
    }

    private ImageWriter getImageWriter(String format) throws IOException {
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(format);
        if (!imageWriters.hasNext()) {
            throw new IOException("No image writer found for PNG.");
        }
        ImageWriter imageWriter = imageWriters.next();
        return imageWriter;
    }

    private int[] packDataIntoArray(GImageFormat format, InputStream data, long dataLength) throws IOException {
        int offset = 0;
        int[] arr = new int[this.width * this.height];
        for (int i = 0; i < arr.length; ++i) {
            int argbValue;
            if (format == GImageFormat.RGB_ALPHA_4BYTE) {
                int argbValue2;
                int blue = 0;
                int green = 0;
                int red = 0;
                int alpha = 0;
                if ((long)offset < dataLength) {
                    blue = data.read() & 0xFF;
                    green = data.read() & 0xFF;
                    red = data.read() & 0xFF;
                    alpha = data.read() & 0xFF;
                }
                int alpha_shifted = (alpha ^= 0xFFFFFFFF) << 24 & 0xFF000000;
                int red_shifted = red << 16 & 0xFF0000;
                int green_shifted = green << 8 & 0xFF00;
                int blue_shifted = blue << 0 & 0xFF;
                arr[i] = argbValue2 = alpha_shifted | red_shifted | green_shifted | blue_shifted;
                offset += 4;
                continue;
            }
            if (format != GImageFormat.GRAY_ALPHA_2BYTE) continue;
            int alpha = 0;
            int gray = 0;
            if ((long)offset < dataLength) {
                alpha = data.read() & 0xFF;
                gray = data.read() & 0xFF;
            }
            int alpha_shifted = (alpha ^= 0xFFFFFFFF) << 24 & 0xFF000000;
            int red_shifted = gray << 16 & 0xFF0000;
            int green_shifted = gray << 8 & 0xFF00;
            int blue_shifted = gray << 0 & 0xFF;
            arr[i] = argbValue = alpha_shifted | red_shifted | green_shifted | blue_shifted;
            offset += 2;
        }
        return arr;
    }
}

