/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import tim.prune.I18nManager;

public class CombinedListAndModel
extends JList<String> {
    private DefaultListModel<String> _model = null;
    private final int _key;
    private int _maxNumEntries = 0;
    private boolean _tooManyEntries = false;
    private boolean _unlimited = false;

    public CombinedListAndModel(int n) {
        this.setSelectionMode(0);
        this._model = new DefaultListModel();
        this.setModel(this._model);
        this._key = n;
    }

    public void setMaxNumEntries(int n) {
        this._maxNumEntries = n;
    }

    public void setUnlimited(boolean bl) {
        this._unlimited = bl;
    }

    public int getKey() {
        return this._key;
    }

    public void addItem(String string) {
        if (!this._tooManyEntries) {
            this._model.addElement(string);
            if (this._maxNumEntries > 0 && !this._unlimited && this._model.getSize() > this._maxNumEntries) {
                this._tooManyEntries = true;
                this._model.clear();
                this._model.addElement(I18nManager.getText("dialog.settimezone.list.toomany"));
            }
        }
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (this._tooManyEntries || n < 0) {
            return null;
        }
        return this._model.getElementAt(n);
    }

    public void clear() {
        this._model.clear();
        this._tooManyEntries = false;
        this._unlimited = false;
    }

    public void selectItem(String string) {
        if (!this._tooManyEntries && string != null) {
            this.setSelectedValue(string, true);
        }
    }
}

