/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.Optional;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.execution.TaskExecution;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.execution.plan.MissingTaskDependencyDetector;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.work.AsyncWorkTracker;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private final ExecutionHistoryStore executionHistoryStore;
    private final BuildOperationRunner buildOperationRunner;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ExecutionEngine executionEngine;
    private final InputFingerprinter inputFingerprinter;
    private final ListenerManager listenerManager;
    private final ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry;
    private final FileCollectionFactory fileCollectionFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final PathToFileResolver fileResolver;
    private final MissingTaskDependencyDetector missingTaskDependencyDetector;

    public ExecuteActionsTaskExecuter(ExecutionHistoryStore executionHistoryStore, BuildOperationRunner buildOperationRunner, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, TaskCacheabilityResolver taskCacheabilityResolver, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ExecutionEngine executionEngine, InputFingerprinter inputFingerprinter, ListenerManager listenerManager, ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry, FileCollectionFactory fileCollectionFactory, TaskDependencyFactory taskDependencyFactory, PathToFileResolver fileResolver, MissingTaskDependencyDetector missingTaskDependencyDetector) {
        this.executionHistoryStore = executionHistoryStore;
        this.buildOperationRunner = buildOperationRunner;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.executionEngine = executionEngine;
        this.inputFingerprinter = inputFingerprinter;
        this.listenerManager = listenerManager;
        this.reservedFileSystemLocationRegistry = reservedFileSystemLocationRegistry;
        this.fileCollectionFactory = fileCollectionFactory;
        this.taskDependencyFactory = taskDependencyFactory;
        this.fileResolver = fileResolver;
        this.missingTaskDependencyDetector = missingTaskDependencyDetector;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskExecution work = new TaskExecution(task, context, this.actionListener, this.asyncWorkTracker, this.buildOperationRunner, this.classLoaderHierarchyHasher, this.executionHistoryStore, this.fileCollectionFactory, this.fileResolver, this.inputFingerprinter, this.listenerManager, this.reservedFileSystemLocationRegistry, this.taskCacheabilityResolver, this.taskDependencyFactory, this.missingTaskDependencyDetector);
        try {
            return this.executeIfValid(task, state, context, work);
        }
        catch (WorkValidationException ex) {
            state.setOutcome((RuntimeException)((Object)ex));
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
    }

    private TaskExecuterResult executeIfValid(TaskInternal task, TaskStateInternal state, TaskExecutionContext context, TaskExecution work) {
        ExecutionEngine.Request request = this.executionEngine.createRequest((UnitOfWork)work);
        context.getTaskExecutionMode().getRebuildReason().ifPresent(arg_0 -> ((ExecutionEngine.Request)request).forceNonIncremental(arg_0));
        request.withValidationContext(context.getValidationContext());
        final ExecutionEngine.Result result = request.execute();
        result.getExecution().ifSuccessfulOrElse(success -> state.setOutcome(ExecuteActionsTaskExecuter.convertOutcome(success.getOutcome())), failure -> state.setOutcome((RuntimeException)((Object)new TaskExecutionException(task, (Throwable)failure))));
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getReusedOutputOriginMetadata();
            }

            @Override
            public boolean executedIncrementally() {
                return (Boolean)result.getExecution().map(executionResult -> executionResult.getOutcome() == ExecutionEngine.ExecutionOutcome.EXECUTED_INCREMENTALLY).getOrMapFailure(throwable -> false);
            }

            @Override
            public List<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public CachingState getCachingState() {
                return result.getCachingState();
            }
        };
    }

    private static TaskExecutionOutcome convertOutcome(ExecutionEngine.ExecutionOutcome model) {
        switch (model) {
            case FROM_CACHE: {
                return TaskExecutionOutcome.FROM_CACHE;
            }
            case UP_TO_DATE: {
                return TaskExecutionOutcome.UP_TO_DATE;
            }
            case SHORT_CIRCUITED: {
                return TaskExecutionOutcome.NO_SOURCE;
            }
            case EXECUTED_INCREMENTALLY: 
            case EXECUTED_NON_INCREMENTALLY: {
                return TaskExecutionOutcome.EXECUTED;
            }
        }
        throw new AssertionError();
    }
}

