/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.cache.ObjectHolder;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.HashCode;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileEdge;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class IncrementalNativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Logger logger = LoggerFactory.getLogger(IncrementalNativeCompiler.class);
    private final Compiler<T> delegateCompiler;
    private final TaskOutputsInternal outputs;
    private final Deleter deleter;
    private final ObjectHolder<CompilationState> compileStateCache;
    private final IncrementalCompilation incrementalCompilation;

    public IncrementalNativeCompiler(TaskOutputsInternal outputs, Compiler<T> delegateCompiler, Deleter deleter, ObjectHolder<CompilationState> compileStateCache, IncrementalCompilation incrementalCompilation) {
        this.outputs = outputs;
        this.delegateCompiler = delegateCompiler;
        this.deleter = deleter;
        this.compileStateCache = compileStateCache;
        this.incrementalCompilation = incrementalCompilation;
    }

    public WorkResult execute(T spec) {
        WorkResult workResult = spec.isIncrementalCompile() ? this.doIncrementalCompile(this.incrementalCompilation, spec) : this.doCleanIncrementalCompile(spec);
        this.compileStateCache.set((Object)this.incrementalCompilation.getFinalState());
        return workResult;
    }

    private List<File> getSourceFilesForPch(T spec) {
        if (spec.getPreCompiledHeader() != null) {
            ImmutableList.Builder sourceFiles = ImmutableList.builder();
            for (File sourceFile : spec.getSourceFiles()) {
                boolean usePCH;
                SourceFileState state = this.incrementalCompilation.getFinalState().getState(sourceFile);
                HashCode hash = state.getHash();
                ArrayList<String> headers = new ArrayList<String>();
                for (IncludeFileEdge edge : state.getEdges()) {
                    if (!hash.equals((Object)edge.getIncludedBy())) continue;
                    headers.add(edge.getIncludePath());
                }
                String header = spec.getPreCompiledHeader();
                boolean bl = usePCH = !headers.isEmpty() && header.equals(headers.get(0));
                if (usePCH) {
                    sourceFiles.add((Object)sourceFile);
                    continue;
                }
                boolean containsHeader = headers.contains(header);
                if (!containsHeader) continue;
                this.logger.warn(IncrementalNativeCompiler.getCantUsePCHMessage(spec.getPreCompiledHeader(), sourceFile));
            }
            return sourceFiles.build();
        }
        return Collections.emptyList();
    }

    private static String getCantUsePCHMessage(String pchHeader, File sourceFile) {
        return "The source file ".concat(sourceFile.getName()).concat(" includes the header ").concat(pchHeader).concat(" but it is not the first declared header, so the pre-compiled header will not be used.");
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, T spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        spec.setSourceFilesForPch(this.getSourceFilesForPch(spec));
        return this.delegateCompiler.execute(spec);
    }

    protected WorkResult doCleanIncrementalCompile(T spec) {
        boolean deleted = this.cleanPreviousOutputs((NativeCompileSpec)spec);
        spec.setSourceFilesForPch(this.getSourceFilesForPch(spec));
        WorkResult compileResult = this.delegateCompiler.execute(spec);
        if (deleted && !compileResult.getDidWork()) {
            return WorkResults.didWork((boolean)true);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        return StaleOutputCleaner.cleanOutputs((Deleter)this.deleter, (Iterable)this.outputs.getPreviousOutputFiles(), (File)spec.getObjectFileDir());
    }
}

