#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 sop-core
version:              0.5.0.2
visibility:           public
id:                   sop-core-0.5.0.2-6A7lf58QPy2GZuvhMdgskj
key:                  sop-core-0.5.0.2-6A7lf58QPy2GZuvhMdgskj
license:              BSD-3-Clause
maintainer:           andres@well-typed.com
author:
    Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>

synopsis:             True Sums of Products
description:
    Implementation of n-ary sums and n-ary products.

    The module "Data.SOP" is the main module of this library and contains
    more detailed documentation.

    The main use case of this package is to serve as the core of
    @<https://hackage.haskell.org/package/generics-sop generics-sop>@.

    A detailed description of the ideas behind this library is provided by
    the paper:

    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.

category:             Data
abi:                  90199cb31c656b9925928d923f5953ec
exposed:              True
exposed-modules:
    Data.SOP Data.SOP.BasicFunctors Data.SOP.Classes
    Data.SOP.Constraint Data.SOP.Dict Data.SOP.NP Data.SOP.NS
    Data.SOP.Sing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/sop-core-0.5.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/sop-core-0.5.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/sop-core-0.5.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-sop-core
hs-libraries:         HSsop-core-0.5.0.2-6A7lf58QPy2GZuvhMdgskj
depends:              base-4.17.2.1 deepseq-1.4.8.0
haddock-interfaces:   /usr/share/doc/haskell-sop-core/html/sop-core.haddock
haddock-html:         /usr/share/doc/haskell-sop-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

