/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import net.sourceforge.jnlp.security.VariableX509TrustManager;

public class VariableX509TrustManagerJDK7
extends X509ExtendedTrustManager {
    private VariableX509TrustManager vX509TM = VariableX509TrustManager.getInstance();

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.vX509TM.checkTrustClient(chain, authType, null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.vX509TM.checkTrustServer(chain, authType, null, null, null);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.vX509TM.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrustClient(chain, authType, socket, null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrustServer(chain, authType, socket, null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrustClient(chain, authType, null, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrustServer(chain, authType, null, engine);
    }

    private void checkTrustServer(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
        String hostName = null;
        if (socket != null) {
            hostName = ((SSLSocket)socket).getHandshakeSession().getPeerHost();
        } else if (engine != null) {
            hostName = engine.getHandshakeSession().getPeerHost();
        }
        this.vX509TM.checkTrustServer(chain, authType, hostName, (SSLSocket)socket, engine);
    }

    private void checkTrustClient(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
        String hostName = null;
        if (socket != null) {
            hostName = ((SSLSocket)socket).getHandshakeSession().getPeerHost();
        } else if (engine != null) {
            hostName = engine.getHandshakeSession().getPeerHost();
        }
        this.vX509TM.checkTrustClient(chain, authType, hostName);
    }
}

