/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RestorePropertyAction
extends AbstractAction {
    private final IntFunction<String> keyFn;
    private final IntFunction<String> valueFn;
    private final Supplier<OsmPrimitive> objectSp;
    private final ListSelectionModel selectionModel;

    public RestorePropertyAction(IntFunction<String> keyFn, IntFunction<String> valueFn, Supplier<OsmPrimitive> objectSp, ListSelectionModel selectionModel) {
        super(I18n.tr("Restore selected tags", new Object[0]));
        this.keyFn = keyFn;
        this.valueFn = valueFn;
        this.objectSp = objectSp;
        this.selectionModel = selectionModel;
        new ImageProvider("undo").getResource().attachImageIcon(this, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OsmPrimitive primitive = this.objectSp.get();
        if (primitive == null) {
            return;
        }
        Map changes = TableHelper.selectedIndices(this.selectionModel).boxed().collect(HashMap::new, (m, i) -> m.put(this.keyFn.apply((int)i), this.valueFn.apply((int)i)), HashMap::putAll);
        ChangePropertyCommand command = new ChangePropertyCommand(Collections.singleton(primitive), changes);
        UndoRedoHandler.getInstance().add(command);
    }
}

