/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PlayHeadDragMode
extends MapMode {
    private boolean dragging;
    private Point mousePos;
    private Point mouseStart;
    private final transient PlayHeadMarker playHeadMarker;

    public PlayHeadDragMode(PlayHeadMarker m) {
        super(I18n.tr("Drag play head", new Object[0]), "playheaddrag", I18n.tr("Drag play head", new Object[0]), (Shortcut)null, Cursor.getPredefinedCursor(13));
        this.playHeadMarker = m;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.addMouseListener(this);
        map.mapView.addMouseMotionListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.mapView.removeMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.mouseStart = this.mousePos = ev.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.mouseStart == null || this.mousePos == null) {
            return;
        }
        if ((ev.getModifiersEx() & 0x400) == 0) {
            return;
        }
        Point p = ev.getPoint();
        if (!this.dragging) {
            if (p.distance(this.mouseStart) < 3.0) {
                return;
            }
            this.playHeadMarker.startDrag();
            this.dragging = true;
        }
        if (p.distance(this.mousePos) == 0.0) {
            return;
        }
        this.playHeadMarker.drag(MainApplication.getMap().mapView.getEastNorth(ev.getX(), ev.getY()));
        this.mousePos = p;
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.mouseStart = null;
        if (ev.getButton() != 1 || !this.dragging) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(ev);
        EastNorth en = MainApplication.getMap().mapView.getEastNorth(ev.getX(), ev.getY());
        if (!this.shift) {
            this.playHeadMarker.reposition(en);
        } else {
            this.playHeadMarker.synchronize(en);
        }
        this.mousePos = null;
        this.dragging = false;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Drag play head and release near track to play audio from there; SHIFT+release to synchronize audio at that point.", new Object[0]);
    }
}

