/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.CoordinateConflictResolveCommand;
import org.openstreetmap.josm.command.conflict.DeletedStateConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PropertiesMergeModel
extends ChangeNotifier {
    public static final String RESOLVED_COMPLETELY_PROP = PropertiesMergeModel.class.getName() + ".resolvedCompletely";
    public static final String DELETE_PRIMITIVE_PROP = PropertiesMergeModel.class.getName() + ".deletePrimitive";
    private OsmPrimitive my;
    private LatLon myCoords;
    private LatLon theirCoords;
    private MergeDecisionType coordMergeDecision = MergeDecisionType.UNDECIDED;
    private boolean myDeletedState;
    private boolean theirDeletedState;
    private List<OsmPrimitive> myReferrers;
    private List<OsmPrimitive> theirReferrers;
    private MergeDecisionType deletedMergeDecision = MergeDecisionType.UNDECIDED;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Boolean resolvedCompletely = null;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void fireCompletelyResolved() {
        Boolean oldValue = this.resolvedCompletely;
        this.resolvedCompletely = this.isResolvedCompletely();
        this.support.firePropertyChange(RESOLVED_COMPLETELY_PROP, oldValue, this.resolvedCompletely);
    }

    public boolean isDecidedCoord() {
        return this.coordMergeDecision != MergeDecisionType.UNDECIDED;
    }

    public boolean isDecidedDeletedState() {
        return this.deletedMergeDecision != MergeDecisionType.UNDECIDED;
    }

    public boolean isCoordMergeDecision(MergeDecisionType decision) {
        return this.coordMergeDecision == decision;
    }

    public boolean isDeletedStateDecision(MergeDecisionType decision) {
        return this.deletedMergeDecision == decision;
    }

    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.my = conflict.getMy();
        OsmPrimitive their = conflict.getTheir();
        if (this.my instanceof Node) {
            this.myCoords = ((Node)this.my).getCoor();
            this.theirCoords = ((Node)their).getCoor();
        } else {
            this.myCoords = null;
            this.theirCoords = null;
        }
        this.myDeletedState = conflict.isMyDeleted() || this.my.isDeleted();
        this.theirDeletedState = their.isDeleted();
        this.myReferrers = this.my.getDataSet() == null ? Collections.emptyList() : this.my.getReferrers();
        this.theirReferrers = their.getDataSet() == null ? Collections.emptyList() : their.getReferrers();
        this.coordMergeDecision = MergeDecisionType.UNDECIDED;
        this.deletedMergeDecision = MergeDecisionType.UNDECIDED;
        this.fireStateChanged();
        this.fireCompletelyResolved();
    }

    public LatLon getMyCoords() {
        return this.myCoords;
    }

    public LatLon getTheirCoords() {
        return this.theirCoords;
    }

    public LatLon getMergedCoords() {
        switch (this.coordMergeDecision) {
            case KEEP_MINE: {
                return this.myCoords;
            }
            case KEEP_THEIR: {
                return this.theirCoords;
            }
        }
        return null;
    }

    public void decideCoordsConflict(MergeDecisionType decision) {
        this.coordMergeDecision = decision;
        this.fireStateChanged();
        this.fireCompletelyResolved();
    }

    public Boolean getMyDeletedState() {
        return this.myDeletedState;
    }

    public Boolean getTheirDeletedState() {
        return this.theirDeletedState;
    }

    public Boolean getMergedDeletedState() {
        switch (this.deletedMergeDecision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
        }
        return null;
    }

    public List<OsmPrimitive> getMyReferrers() {
        return this.myReferrers;
    }

    public List<OsmPrimitive> getTheirReferrers() {
        return this.theirReferrers;
    }

    private boolean getMergedDeletedState(MergeDecisionType decision) {
        switch (decision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
        }
        return false;
    }

    public void decideDeletedStateConflict(MergeDecisionType decision) {
        CheckParameterUtil.ensureParameterNotNull((Object)decision, "decision");
        boolean oldMergedDeletedState = this.getMergedDeletedState(this.deletedMergeDecision);
        boolean newMergedDeletedState = this.getMergedDeletedState(decision);
        this.deletedMergeDecision = decision;
        this.fireStateChanged();
        this.fireCompletelyResolved();
        if (oldMergedDeletedState != newMergedDeletedState) {
            this.support.firePropertyChange(DELETE_PRIMITIVE_PROP, oldMergedDeletedState, newMergedDeletedState);
        }
    }

    public boolean hasCoordConflict() {
        if (this.myCoords == null && this.theirCoords != null) {
            return true;
        }
        if (this.myCoords != null && this.theirCoords == null) {
            return true;
        }
        if (this.myCoords == null && this.theirCoords == null) {
            return false;
        }
        return this.myCoords != null && !this.myCoords.equalsEpsilon(this.theirCoords, 1.0E-7);
    }

    public boolean hasDeletedStateConflict() {
        return this.myDeletedState != this.theirDeletedState;
    }

    public boolean isResolvedCompletely() {
        boolean ret = true;
        if (this.hasCoordConflict()) {
            boolean bl = ret = ret && this.coordMergeDecision != MergeDecisionType.UNDECIDED;
        }
        if (this.hasDeletedStateConflict()) {
            ret = ret && this.deletedMergeDecision != MergeDecisionType.UNDECIDED;
        }
        return ret;
    }

    public List<Command> buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (this.hasCoordConflict() && this.isDecidedCoord()) {
            cmds.add(new CoordinateConflictResolveCommand(conflict, this.coordMergeDecision));
        }
        if (this.hasDeletedStateConflict() && this.isDecidedDeletedState()) {
            cmds.add(new DeletedStateConflictResolveCommand(conflict, this.deletedMergeDecision));
        }
        return cmds;
    }

    public OsmPrimitive getMyPrimitive() {
        return this.my;
    }
}

