/*
 * Decompiled with CFR 0.152.
 */
package jnr.a64asm;

import java.util.EnumMap;
import java.util.Map;
import jnr.a64asm.SYSREG_CODE;

public final class SysRegDescription {
    final SYSREG_CODE code;
    final int reg_code;
    private static final Map<SYSREG_CODE, SysRegDescription> sysRegtable = new EnumMap<SYSREG_CODE, SysRegDescription>(SYSREG_CODE.class);
    private static final SysRegDescription[] SYSREG_tb = new SysRegDescription[]{SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_EL1, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ELR_EL1, 0, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SP_EL0, 0, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSEL, 0, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DAIF, 3, 2, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CURRENTEL, 0, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.NZCV, 3, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FPCR, 3, 4, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FPSR, 3, 4, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DSPSR_EL0, 3, 5, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DLR_EL0, 3, 5, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_EL2, 4, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ELR_EL2, 4, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SP_EL1, 4, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_IRQ, 4, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_ABT, 4, 3, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_UND, 4, 3, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_FIQ, 4, 3, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_EL3, 6, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ELR_EL3, 6, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SP_EL2, 6, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_SVC, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SPSR_HYP, 4, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MIDR_EL1, 3, 0, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CTR_EL0, 3, 3, 0, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MPIDR_EL1, 3, 0, 0, 0, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.REVIDR_EL1, 3, 0, 0, 0, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AIDR_EL1, 3, 1, 0, 0, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DCZID_EL0, 3, 3, 0, 0, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_DFR0_EL1, 3, 0, 0, 1, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_PFR0_EL1, 3, 0, 0, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_PFR1_EL1, 3, 0, 0, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AFR0_EL1, 3, 0, 0, 1, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_MMFR0_EL1, 3, 0, 0, 1, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_MMFR1_EL1, 3, 0, 0, 1, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_MMFR2_EL1, 3, 0, 0, 1, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_MMFR3_EL1, 3, 0, 0, 1, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR0_EL1, 3, 0, 0, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR1_EL1, 3, 0, 0, 2, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR2_EL1, 3, 0, 0, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR3_EL1, 3, 0, 0, 2, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR4_EL1, 3, 0, 0, 2, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_ISAR5_EL1, 3, 0, 0, 2, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MVFR0_EL1, 3, 0, 0, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MVFR1_EL1, 3, 0, 0, 3, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MVFR2_EL1, 3, 0, 0, 3, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CCSIDR_EL1, 3, 1, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64PFR0_EL1, 3, 0, 0, 4, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64PFR1_EL1, 3, 0, 0, 4, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64DFR0_EL1, 3, 0, 0, 5, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64DFR1_EL1, 3, 0, 0, 5, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64ISAR0_EL1, 3, 0, 0, 6, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64ISAR1_EL1, 3, 0, 0, 6, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64MMFR0_EL1, 3, 0, 0, 7, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64MMFR1_EL1, 3, 0, 0, 7, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64AFR0_EL1, 3, 0, 0, 5, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ID_AA64AFR1_EL1, 3, 0, 0, 5, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CLIDR_EL1, 3, 1, 0, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CSSELR_EL1, 3, 2, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VPIDR_EL2, 3, 4, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VMPIDR_EL2, 3, 4, 0, 0, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SCTLR_EL1, 3, 0, 1, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SCTLR_EL2, 3, 4, 1, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SCTLR_EL3, 3, 6, 1, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ACTLR_EL1, 3, 0, 1, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ACTLR_EL2, 3, 4, 1, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ACTLR_EL3, 3, 6, 1, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CPACR_EL1, 3, 0, 1, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CPTR_EL2, 3, 4, 1, 1, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CPTR_EL3, 3, 6, 1, 1, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SCR_EL3, 3, 6, 1, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.HCR_EL2, 3, 4, 1, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDCR_EL2, 3, 4, 1, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDCR_EL3, 3, 6, 1, 3, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.HSTR_EL2, 3, 4, 1, 1, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.HACR_EL2, 3, 4, 1, 1, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TTBR0_EL1, 3, 0, 2, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TTBR1_EL1, 3, 0, 2, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TTBR0_EL2, 3, 4, 2, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TTBR0_EL3, 3, 6, 2, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VTTBR_EL2, 3, 4, 2, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TCR_EL1, 3, 0, 2, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TCR_EL2, 3, 4, 2, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TCR_EL3, 3, 6, 2, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VTCR_EL2, 3, 4, 2, 1, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR0_EL1, 3, 0, 5, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR1_EL1, 3, 0, 5, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR0_EL2, 3, 4, 5, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR1_EL2, 3, 4, 5, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR0_EL3, 3, 6, 5, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AFSR1_EL3, 3, 6, 5, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ESR_EL1, 3, 0, 5, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ESR_EL2, 3, 4, 5, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ESR_EL3, 3, 6, 5, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FPEXC32_EL2, 3, 4, 5, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FAR_EL1, 3, 0, 6, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FAR_EL2, 3, 4, 6, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.FAR_EL3, 3, 6, 6, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.HPFAR_EL2, 3, 4, 6, 0, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PAR_EL1, 3, 0, 7, 4, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MAIR_EL1, 3, 0, 10, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MAIR_EL2, 3, 4, 10, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MAIR_EL3, 3, 6, 10, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AMAIR_EL1, 3, 0, 10, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AMAIR_EL2, 3, 4, 10, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.AMAIR_EL3, 3, 6, 10, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VBAR_EL1, 3, 0, 12, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VBAR_EL2, 3, 4, 12, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.VBAR_EL3, 3, 6, 12, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RVBAR_EL1, 3, 0, 12, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RVBAR_EL2, 3, 4, 12, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RVBAR_EL3, 3, 6, 12, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RMR_EL1, 3, 0, 12, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RMR_EL2, 3, 4, 12, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.RMR_EL3, 3, 6, 12, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.ISR_EL1, 3, 0, 12, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CONTEXTIDR_EL1, 3, 0, 13, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TPIDR_EL0, 3, 3, 13, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TPIDRRO_EL0, 3, 3, 13, 0, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TPIDR_EL1, 3, 0, 13, 0, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TPIDR_EL2, 3, 4, 13, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TPIDR_EL3, 3, 6, 13, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TEECR32_EL1, 2, 2, 0, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTFRQ_EL0, 3, 3, 14, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTPCT_EL0, 3, 3, 14, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTVCT_EL0, 3, 3, 14, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTVOFF_EL2, 3, 4, 14, 0, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTKCTL_EL1, 3, 0, 14, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTHCTL_EL2, 3, 4, 14, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTP_TVAL_EL0, 3, 3, 14, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTP_CTL_EL0, 3, 3, 14, 2, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTP_CVAL_EL0, 3, 3, 14, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTV_TVAL_EL0, 3, 3, 14, 3, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTV_CTL_EL0, 3, 3, 14, 3, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTV_CVAL_EL0, 3, 3, 14, 3, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTHP_TVAL_EL2, 3, 4, 14, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTHP_CTL_EL2, 3, 4, 14, 2, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTHP_CVAL_EL2, 3, 4, 14, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTPS_TVAL_EL1, 3, 7, 14, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTPS_CTL_EL1, 3, 7, 14, 2, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.CNTPS_CVAL_EL1, 3, 7, 14, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DACR32_EL2, 3, 4, 3, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.IFSR32_EL2, 3, 4, 5, 0, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.TEEHBR32_EL1, 2, 2, 1, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.SDER32_EL3, 3, 6, 1, 1, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDSCR_EL1, 2, 0, 0, 2, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDCCSR_EL0, 2, 3, 0, 1, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDCCINT_EL1, 2, 0, 0, 2, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGDTR_EL0, 2, 3, 0, 4, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGDTRRX_EL0, 2, 3, 0, 5, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGDTRTX_EL0, 2, 3, 0, 5, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSDTRRX_EL1, 2, 0, 0, 0, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSDTRTX_EL1, 2, 0, 0, 3, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSECCR_EL1, 2, 0, 0, 6, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGVCR32_EL2, 2, 4, 0, 7, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR0_EL1, 2, 0, 0, 0, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR1_EL1, 2, 0, 0, 1, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR2_EL1, 2, 0, 0, 2, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR3_EL1, 2, 0, 0, 3, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR4_EL1, 2, 0, 0, 4, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR5_EL1, 2, 0, 0, 5, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR6_EL1, 2, 0, 0, 6, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR7_EL1, 2, 0, 0, 7, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR8_EL1, 2, 0, 0, 8, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR9_EL1, 2, 0, 0, 9, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR10_EL1, 2, 0, 0, 10, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR11_EL1, 2, 0, 0, 11, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR12_EL1, 2, 0, 0, 12, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR13_EL1, 2, 0, 0, 13, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR14_EL1, 2, 0, 0, 14, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBVR15_EL1, 2, 0, 0, 15, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR0_EL1, 2, 0, 0, 0, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR1_EL1, 2, 0, 0, 1, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR2_EL1, 2, 0, 0, 2, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR3_EL1, 2, 0, 0, 3, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR4_EL1, 2, 0, 0, 4, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR5_EL1, 2, 0, 0, 5, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR6_EL1, 2, 0, 0, 6, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR7_EL1, 2, 0, 0, 7, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR8_EL1, 2, 0, 0, 8, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR9_EL1, 2, 0, 0, 9, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR10_EL1, 2, 0, 0, 10, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR11_EL1, 2, 0, 0, 11, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR12_EL1, 2, 0, 0, 12, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR13_EL1, 2, 0, 0, 13, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR14_EL1, 2, 0, 0, 14, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGBCR15_EL1, 2, 0, 0, 15, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR0_EL1, 2, 0, 0, 0, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR1_EL1, 2, 0, 0, 1, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR2_EL1, 2, 0, 0, 2, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR3_EL1, 2, 0, 0, 3, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR4_EL1, 2, 0, 0, 4, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR5_EL1, 2, 0, 0, 5, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR6_EL1, 2, 0, 0, 6, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR7_EL1, 2, 0, 0, 7, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR8_EL1, 2, 0, 0, 8, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR9_EL1, 2, 0, 0, 9, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR10_EL1, 2, 0, 0, 10, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR11_EL1, 2, 0, 0, 11, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR12_EL1, 2, 0, 0, 12, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR13_EL1, 2, 0, 0, 13, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR14_EL1, 2, 0, 0, 14, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWVR15_EL1, 2, 0, 0, 15, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR0_EL1, 2, 0, 0, 0, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR1_EL1, 2, 0, 0, 1, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR2_EL1, 2, 0, 0, 2, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR3_EL1, 2, 0, 0, 3, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR4_EL1, 2, 0, 0, 4, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR5_EL1, 2, 0, 0, 5, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR6_EL1, 2, 0, 0, 6, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR7_EL1, 2, 0, 0, 7, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR8_EL1, 2, 0, 0, 8, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR9_EL1, 2, 0, 0, 9, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR10_EL1, 2, 0, 0, 10, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR11_EL1, 2, 0, 0, 11, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR12_EL1, 2, 0, 0, 12, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR13_EL1, 2, 0, 0, 13, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR14_EL1, 2, 0, 0, 14, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGWCR15_EL1, 2, 0, 0, 15, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.MDRAR_EL1, 2, 0, 1, 0, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSLAR_EL1, 2, 0, 1, 0, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSLSR_EL1, 2, 0, 1, 1, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.OSDLR_EL1, 2, 0, 1, 3, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGPRCR_EL1, 2, 0, 1, 4, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGCLAIMSET_EL1, 2, 0, 7, 8, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGCLAIMCLR_EL1, 2, 0, 7, 9, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.DBGAUTHSTATUS_EL1, 2, 0, 7, 14, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCR_EL0, 3, 3, 9, 12, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCNTENSET_EL0, 3, 3, 9, 12, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCNTENCLR_EL0, 3, 3, 9, 12, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMOVSCLR_EL0, 3, 3, 9, 12, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMSWINC_EL0, 3, 3, 9, 12, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMSELR_EL0, 3, 3, 9, 12, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCEID0_EL0, 3, 3, 9, 12, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCEID1_EL0, 3, 3, 9, 12, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCCNTR_EL0, 3, 3, 9, 13, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMXEVTYPER_EL0, 3, 3, 9, 13, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMXEVCNTR_EL0, 3, 3, 9, 13, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMUSERENR_EL0, 3, 3, 9, 14, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMINTENSET_EL1, 3, 0, 9, 14, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMINTENCLR_EL1, 3, 0, 9, 14, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMOVSSET_EL0, 3, 3, 9, 14, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR0_EL0, 3, 3, 14, 8, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR1_EL0, 3, 3, 14, 8, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR2_EL0, 3, 3, 14, 8, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR3_EL0, 3, 3, 14, 8, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR4_EL0, 3, 3, 14, 8, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR5_EL0, 3, 3, 14, 8, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR6_EL0, 3, 3, 14, 8, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR7_EL0, 3, 3, 14, 8, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR8_EL0, 3, 3, 14, 9, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR9_EL0, 3, 3, 14, 9, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR10_EL0, 3, 3, 14, 9, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR11_EL0, 3, 3, 14, 9, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR12_EL0, 3, 3, 14, 9, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR13_EL0, 3, 3, 14, 9, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR14_EL0, 3, 3, 14, 9, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR15_EL0, 3, 3, 14, 9, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR16_EL0, 3, 3, 14, 10, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR17_EL0, 3, 3, 14, 10, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR18_EL0, 3, 3, 14, 10, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR19_EL0, 3, 3, 14, 10, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR20_EL0, 3, 3, 14, 10, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR21_EL0, 3, 3, 14, 10, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR22_EL0, 3, 3, 14, 10, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR23_EL0, 3, 3, 14, 10, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR24_EL0, 3, 3, 14, 11, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR25_EL0, 3, 3, 14, 11, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR26_EL0, 3, 3, 14, 11, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR27_EL0, 3, 3, 14, 11, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR28_EL0, 3, 3, 14, 11, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR29_EL0, 3, 3, 14, 11, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVCNTR30_EL0, 3, 3, 14, 11, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER0_EL0, 3, 3, 14, 12, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER1_EL0, 3, 3, 14, 12, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER2_EL0, 3, 3, 14, 12, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER3_EL0, 3, 3, 14, 12, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER4_EL0, 3, 3, 14, 12, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER5_EL0, 3, 3, 14, 12, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER6_EL0, 3, 3, 14, 12, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER7_EL0, 3, 3, 14, 12, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER8_EL0, 3, 3, 14, 13, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER9_EL0, 3, 3, 14, 13, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER10_EL0, 3, 3, 14, 13, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER11_EL0, 3, 3, 14, 13, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER12_EL0, 3, 3, 14, 13, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER13_EL0, 3, 3, 14, 13, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER14_EL0, 3, 3, 14, 13, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER15_EL0, 3, 3, 14, 13, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER16_EL0, 3, 3, 14, 14, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER17_EL0, 3, 3, 14, 14, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER18_EL0, 3, 3, 14, 14, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER19_EL0, 3, 3, 14, 14, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER20_EL0, 3, 3, 14, 14, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER21_EL0, 3, 3, 14, 14, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER22_EL0, 3, 3, 14, 14, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER23_EL0, 3, 3, 14, 14, 7), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER24_EL0, 3, 3, 14, 15, 0), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER25_EL0, 3, 3, 14, 15, 1), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER26_EL0, 3, 3, 14, 15, 2), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER27_EL0, 3, 3, 14, 15, 3), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER28_EL0, 3, 3, 14, 15, 4), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER29_EL0, 3, 3, 14, 15, 5), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMEVTYPER30_EL0, 3, 3, 14, 15, 6), SysRegDescription.MAKE_SYSREGCODE(SYSREG_CODE.PMCCFILTR_EL0, 3, 3, 14, 15, 7)};

    SysRegDescription(SYSREG_CODE code, int op0, int op1, int crn, int crm, int op2) {
        this.code = code;
        this.reg_code = (op0 << 19 | op1 << 16 | crn << 12 | crm << 8 | op2 << 5) >> 5;
    }

    private static final SysRegDescription MAKE_SYSREGCODE(SYSREG_CODE code, int op0, int op1, int crn, int crm, int op2) {
        SysRegDescription id2 = new SysRegDescription(code, op0, op1, crn, crm, op2);
        sysRegtable.put(code, id2);
        return id2;
    }

    private static final SysRegDescription MAKE_SYSREGCODE(SYSREG_CODE code, int op1, int crm, int op2) {
        SysRegDescription id2 = new SysRegDescription(code, 3, op1, 4, crm, op2);
        sysRegtable.put(code, id2);
        return id2;
    }

    public static final SysRegDescription find(SYSREG_CODE code) {
        SysRegDescription id2 = sysRegtable.get((Object)code);
        if (id2 == null) {
            throw new IllegalArgumentException("no description for " + (Object)((Object)code));
        }
        return id2;
    }
}

