/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpoints;

public class LazyOffsetCheckpoints
implements OffsetCheckpoints {
    private final Map<String, LazyOffsetCheckpointMap> lazyCheckpointsByLogDir;

    public LazyOffsetCheckpoints(Map<String, OffsetCheckpointFile> checkpointsByLogDir) {
        this.lazyCheckpointsByLogDir = checkpointsByLogDir.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new LazyOffsetCheckpointMap((OffsetCheckpointFile)entry.getValue())));
    }

    @Override
    public Optional<Long> fetch(String logDir, TopicPartition topicPartition) {
        LazyOffsetCheckpointMap offsetCheckpointFile = this.lazyCheckpointsByLogDir.get(logDir);
        if (offsetCheckpointFile == null) {
            throw new IllegalArgumentException("No checkpoint file for log dir " + logDir);
        }
        return offsetCheckpointFile.fetch(topicPartition);
    }

    static class LazyOffsetCheckpointMap {
        private Map<TopicPartition, Long> offsets;
        private final OffsetCheckpointFile checkpoint;

        LazyOffsetCheckpointMap(OffsetCheckpointFile checkpoint) {
            this.checkpoint = checkpoint;
        }

        synchronized Optional<Long> fetch(TopicPartition topicPartition) {
            if (this.offsets == null) {
                this.offsets = this.checkpoint.read();
            }
            return Optional.ofNullable(this.offsets.get(topicPartition));
        }
    }
}

