/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Incubating;
import org.hibernate.query.AttributeOrder;
import org.hibernate.query.ElementOrder;
import org.hibernate.query.NamedAttributeOrder;
import org.hibernate.query.SortDirection;

@Incubating
public interface Order<X> {
    public static <T> Order<T> asc(SingularAttribute<T, ?> attribute) {
        return new AttributeOrder<T>(SortDirection.ASCENDING, Nulls.NONE, attribute);
    }

    public static <T> Order<T> desc(SingularAttribute<T, ?> attribute) {
        return new AttributeOrder<T>(SortDirection.DESCENDING, Nulls.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction) {
        return new AttributeOrder<T>(direction, Nulls.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction, boolean ignoreCase) {
        return new AttributeOrder<T>(direction, Nulls.NONE, attribute, !ignoreCase);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction, Nulls nullPrecedence) {
        return new AttributeOrder<T>(direction, nullPrecedence, attribute);
    }

    public static <T> Order<T> asc(Class<T> entityClass, String attributeName) {
        return new NamedAttributeOrder<T>(SortDirection.ASCENDING, Nulls.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> desc(Class<T> entityClass, String attributeName) {
        return new NamedAttributeOrder<T>(SortDirection.DESCENDING, Nulls.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction) {
        return new NamedAttributeOrder<T>(direction, Nulls.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction, boolean ignoreCase) {
        return new NamedAttributeOrder<T>(direction, Nulls.NONE, entityClass, attributeName, !ignoreCase);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction, Nulls nullPrecedence) {
        return new NamedAttributeOrder<T>(direction, nullPrecedence, entityClass, attributeName);
    }

    public static Order<Object[]> asc(int element) {
        return new ElementOrder<Object[]>(SortDirection.ASCENDING, Nulls.NONE, element);
    }

    public static Order<Object[]> desc(int element) {
        return new ElementOrder<Object[]>(SortDirection.DESCENDING, Nulls.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction) {
        return new ElementOrder<Object[]>(direction, Nulls.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction, boolean ignoreCase) {
        return new ElementOrder<Object[]>(direction, Nulls.NONE, element, !ignoreCase);
    }

    public static Order<Object[]> by(int element, SortDirection direction, Nulls nullPrecedence) {
        return new ElementOrder<Object[]>(direction, nullPrecedence, element);
    }

    public SortDirection direction();

    public Nulls nullPrecedence();

    public boolean caseSensitive();

    public Class<X> entityClass();

    public String attributeName();

    public SingularAttribute<X, ?> attribute();

    public int element();

    public Order<X> reverse();

    public Order<X> ignoringCase();

    public Order<X> withNullsFirst();

    public Order<X> withNullsLast();

    default public Order<X> reversedIf(boolean reverse) {
        return reverse ? this.reverse() : this;
    }

    default public Order<X> ignoringCaseIf(boolean ignoreCase) {
        return ignoreCase ? this.ignoringCase() : this;
    }

    public static <T> List<Order<? super T>> reverse(List<Order<? super T>> ordering) {
        return ordering.stream().map(Order::reverse).collect(Collectors.toList());
    }

    @Deprecated(since="7", forRemoval=true)
    default public SortDirection getDirection() {
        return this.direction();
    }

    @Deprecated(since="7", forRemoval=true)
    default public Nulls getNullPrecedence() {
        return this.nullPrecedence();
    }

    @Deprecated(since="7", forRemoval=true)
    default public boolean isCaseInsensitive() {
        return !this.caseSensitive();
    }

    @Deprecated(since="7", forRemoval=true)
    default public SingularAttribute<X, ?> getAttribute() {
        return this.attribute();
    }

    @Deprecated(since="7", forRemoval=true)
    default public Class<X> getEntityClass() {
        return this.entityClass();
    }

    @Deprecated(since="7", forRemoval=true)
    default public String getAttributeName() {
        return this.attributeName();
    }

    @Deprecated(since="7", forRemoval=true)
    default public int getElement() {
        return this.element();
    }
}

