/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.representations.idm.ClientRepresentation;

public abstract class AbstractClientConfigWrapper {
    protected final ClientModel clientModel;
    protected final ClientRepresentation clientRep;

    protected AbstractClientConfigWrapper(ClientModel clientModel, ClientRepresentation clientRep) {
        this.clientModel = clientModel;
        this.clientRep = clientRep;
    }

    protected String getAttribute(String attrKey) {
        if (this.clientModel != null) {
            return this.clientModel.getAttribute(attrKey);
        }
        return this.clientRep.getAttributes() == null ? null : (String)this.clientRep.getAttributes().get(attrKey);
    }

    protected String getAttribute(String attrKey, String defaultValue) {
        String value = this.getAttribute(attrKey);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected Object getAttributes() {
        if (this.clientModel != null) {
            return this.clientModel.getAttributes();
        }
        return this.clientRep.getAttributes();
    }

    protected void setAttribute(String attrKey, String attrValue) {
        if (this.clientModel != null) {
            if (attrValue != null) {
                this.clientModel.setAttribute(attrKey, attrValue);
            } else {
                this.clientModel.removeAttribute(attrKey);
            }
        } else if (attrValue != null) {
            if (this.clientRep.getAttributes() == null) {
                this.clientRep.setAttributes(new HashMap());
            }
            this.clientRep.getAttributes().put(attrKey, attrValue);
        } else if (this.clientRep.getAttributes() != null) {
            this.clientRep.getAttributes().put(attrKey, null);
        }
    }

    public List<String> getAttributeMultivalued(String attrKey) {
        String attrValue = this.getAttribute(attrKey);
        if (attrValue == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(attrValue));
    }

    public void setAttributeMultivalued(String attrKey, List<String> attrValues) {
        if (attrValues == null || attrValues.size() == 0) {
            this.setAttribute(attrKey, null);
        } else {
            String attrValueFull = String.join((CharSequence)"##", attrValues);
            this.setAttribute(attrKey, attrValueFull);
        }
    }
}

