/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.CyclicDependencyException;

@ThreadSafe
public final class DependencyGraph<T> {
    private final Map<T, Set<T>> outgoingEdges = new HashMap<T, Set<T>>();
    private final Map<T, Set<T>> incomingEdges = new HashMap<T, Set<T>>();
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> topologicalSort() throws CyclicDependencyException {
        long stamp = this.lock.readLock();
        try {
            ArrayList result = new ArrayList();
            ArrayDeque<T> noIncomingEdges = new ArrayDeque<T>();
            HashMap<T, Integer> temp = new HashMap<T, Integer>();
            for (Map.Entry<T, Set<T>> incoming : this.incomingEdges.entrySet()) {
                int size = incoming.getValue().size();
                T key = incoming.getKey();
                temp.put(key, size);
                if (size != 0) continue;
                noIncomingEdges.add(key);
            }
            while (!noIncomingEdges.isEmpty()) {
                Object n = noIncomingEdges.poll();
                result.add(n);
                temp.remove(n);
                Set<T> elements = this.outgoingEdges.get(n);
                if (elements == null) continue;
                for (T m : elements) {
                    Integer count = (Integer)temp.get(m);
                    count = count - 1;
                    temp.put(m, count);
                    if (count != 0) continue;
                    noIncomingEdges.add(m);
                }
            }
            if (!temp.isEmpty()) {
                throw new CyclicDependencyException("Cycle detected");
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(T from, T to) {
        if (from == null || to == null || from.equals(to)) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        long stamp = this.lock.writeLock();
        try {
            if (this.addOutgoingEdge(from, to)) {
                this.addIncomingEdge(to, from);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependency(T from, T to) {
        long stamp = this.lock.writeLock();
        try {
            Set<T> dependencies = this.outgoingEdges.get(from);
            if (dependencies == null || !dependencies.contains(to)) {
                throw new IllegalArgumentException("Inexistent dependency");
            }
            dependencies.remove(to);
            this.incomingEdges.get(to).remove(from);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void clearAll() {
        long stamp = this.lock.writeLock();
        try {
            this.outgoingEdges.clear();
            this.incomingEdges.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void addIncomingEdge(T to, T from) {
        Set<T> incoming = this.incomingEdges.get(to);
        if (incoming == null) {
            this.incomingEdges.put(to, this.newInitialSet(from));
        } else {
            incoming.add(from);
        }
        if (!this.incomingEdges.containsKey(from)) {
            this.incomingEdges.put(from, new HashSet());
        }
    }

    private boolean addOutgoingEdge(T from, T to) {
        Set<T> outgoing = this.outgoingEdges.get(from);
        if (outgoing == null) {
            this.outgoingEdges.put(from, this.newInitialSet(to));
            return true;
        }
        return outgoing.add(to);
    }

    private Set<T> newInitialSet(T element) {
        HashSet<T> elements = new HashSet<T>();
        elements.add(element);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDependent(T element) {
        long stamp = this.lock.readLock();
        try {
            Set<T> ts = this.incomingEdges.get(element);
            boolean bl = ts != null && !ts.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getDependents(T element) {
        long stamp = this.lock.readLock();
        try {
            Set<T> dependants = this.incomingEdges.get(element);
            if (dependants == null || dependants.isEmpty()) {
                Set set = Collections.emptySet();
                return set;
            }
            Set<T> set = Collections.unmodifiableSet(this.incomingEdges.get(element));
            return set;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T element) {
        long stamp = this.lock.writeLock();
        try {
            if (this.outgoingEdges.remove(element) != null) {
                for (Set<T> values : this.outgoingEdges.values()) {
                    values.remove(element);
                }
            }
            if (this.incomingEdges.remove(element) != null) {
                for (Set<T> values : this.incomingEdges.values()) {
                    values.remove(element);
                }
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

