/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

public class JsonPath {
    public static final JsonPath ROOT_PATH = new JsonPath("$");
    public static final JsonPath ROOT_PATH_LEGACY = new JsonPath(".");
    private final String path;

    public JsonPath(String pathString) {
        if (pathString == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (pathString.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        this.path = pathString;
    }

    public String toString() {
        return this.path;
    }

    public static JsonPath of(String path) {
        return new JsonPath(path);
    }

    public boolean equals(Object obj) {
        return this.path.equals(obj);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isRootPath() {
        return ROOT_PATH.toString().equals(this.path) || ROOT_PATH_LEGACY.toString().equals(this.path);
    }
}

