/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.dictionary.TMDictionaryMaker;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Map;

public class NGramDictionaryMaker {
    BinTrie<Integer> trie = new BinTrie();
    TMDictionaryMaker tmDictionaryMaker = new TMDictionaryMaker();

    public void addPair(IWord first, IWord second) {
        String combine = first.getValue() + "@" + second.getValue();
        Integer frequency = this.trie.get(combine);
        if (frequency == null) {
            frequency = 0;
        }
        this.trie.put(combine, (Integer)(frequency + 1));
        this.tmDictionaryMaker.addPair(first.getLabel(), second.getLabel());
    }

    public boolean saveTxtTo(String path) {
        this.saveNGramToTxt(path + ".ngram.txt");
        this.saveTransformMatrixToTxt(path + ".tr.txt");
        return true;
    }

    public boolean saveNGramToTxt(String path) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path), "UTF-8"));
            for (Map.Entry<String, Integer> entry : this.trie.entrySet()) {
                bw.write(entry.getKey() + " " + entry.getValue());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u4fdd\u5b58NGram\u8bcd\u5178\u5230" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return false;
        }
        return true;
    }

    public boolean saveTransformMatrixToTxt(String path) {
        return this.tmDictionaryMaker.saveTxtTo(path);
    }
}

