/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.cluster;

import com.hankcs.hanlp.mining.cluster.Document;
import com.hankcs.hanlp.mining.cluster.SparseVector;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class Cluster<K>
implements Comparable<Cluster<K>> {
    List<Document<K>> documents_;
    SparseVector composite_;
    SparseVector centroid_;
    List<Cluster<K>> sectioned_clusters_;
    double sectioned_gain_;
    Random random;

    public Cluster() {
        this(new ArrayList<Document<K>>());
    }

    public Cluster(List<Document<K>> documents) {
        this.documents_ = documents;
        this.composite_ = new SparseVector();
        this.random = new Random();
    }

    void set_composite_vector() {
        this.composite_.clear();
        for (Document<K> document : this.documents_) {
            this.composite_.add_vector(document.feature());
        }
    }

    void clear() {
        this.documents_.clear();
        this.composite_.clear();
        if (this.centroid_ != null) {
            this.centroid_.clear();
        }
        if (this.sectioned_clusters_ != null) {
            this.sectioned_clusters_.clear();
        }
        this.sectioned_gain_ = 0.0;
    }

    int size() {
        return this.documents_.size();
    }

    SparseVector centroid_vector() {
        if (this.documents_.size() > 0 && this.composite_.size() == 0) {
            this.set_composite_vector();
        }
        this.centroid_ = (SparseVector)this.composite_vector().clone();
        this.centroid_.normalize();
        return this.centroid_;
    }

    SparseVector composite_vector() {
        return this.composite_;
    }

    List<Document<K>> documents() {
        return this.documents_;
    }

    void add_document(Document doc) {
        doc.feature().normalize();
        this.documents_.add(doc);
        this.composite_.add_vector(doc.feature());
    }

    void remove_document(int index) {
        ListIterator<Document<K>> listIterator = this.documents_.listIterator(index);
        Document<K> document = listIterator.next();
        listIterator.set(null);
        this.composite_.sub_vector(document.feature());
    }

    void refresh() {
        ListIterator<Document<K>> listIterator = this.documents_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != null) continue;
            listIterator.remove();
        }
    }

    double sectioned_gain() {
        return this.sectioned_gain_;
    }

    void set_sectioned_gain() {
        double gain = 0.0;
        if (this.sectioned_gain_ == 0.0 && this.sectioned_clusters_.size() > 1) {
            for (Cluster<K> cluster : this.sectioned_clusters_) {
                gain += cluster.composite_vector().norm();
            }
            gain -= this.composite_.norm();
        }
        this.sectioned_gain_ = gain;
    }

    List<Cluster<K>> sectioned_clusters() {
        return this.sectioned_clusters_;
    }

    void choose_smartly(int ndocs, List<Document> docs) {
        int siz = this.size();
        double[] closest = new double[siz];
        if (siz < ndocs) {
            ndocs = siz;
        }
        int count = 0;
        int index = this.random.nextInt(siz);
        docs.add(this.documents_.get(index));
        ++count;
        double potential = 0.0;
        for (int i = 0; i < this.documents_.size(); ++i) {
            double dist = 1.0 - SparseVector.inner_product(this.documents_.get(i).feature(), this.documents_.get(index).feature());
            potential += dist;
            closest[i] = dist;
        }
        while (count < ndocs) {
            double dist;
            double randval = this.random.nextDouble() * potential;
            for (index = 0; index < this.documents_.size() && !(randval <= (dist = closest[index])); randval -= dist, ++index) {
            }
            if (index == this.documents_.size()) {
                --index;
            }
            docs.add(this.documents_.get(index));
            ++count;
            double new_potential = 0.0;
            for (int i = 0; i < this.documents_.size(); ++i) {
                double min;
                double dist2 = 1.0 - SparseVector.inner_product(this.documents_.get(i).feature(), this.documents_.get(index).feature());
                if (dist2 < (min = closest[i])) {
                    closest[i] = dist2;
                    min = dist2;
                }
                new_potential += min;
            }
            potential = new_potential;
        }
    }

    void section(int nclusters) {
        if (this.size() < nclusters) {
            throw new IllegalArgumentException("\u7c07\u6570\u76ee\u5c0f\u4e8e\u6587\u6863\u6570\u76ee");
        }
        this.sectioned_clusters_ = new ArrayList<Cluster<K>>(nclusters);
        ArrayList<Document> centroids = new ArrayList<Document>(nclusters);
        this.choose_smartly(nclusters, centroids);
        for (int i = 0; i < centroids.size(); ++i) {
            Cluster<K> cluster = new Cluster<K>();
            this.sectioned_clusters_.add(cluster);
        }
        for (Document<K> d : this.documents_) {
            double max_similarity = -1.0;
            int max_index = 0;
            for (int j = 0; j < centroids.size(); ++j) {
                double similarity = SparseVector.inner_product(d.feature(), ((Document)centroids.get(j)).feature());
                if (!(max_similarity < similarity)) continue;
                max_similarity = similarity;
                max_index = j;
            }
            this.sectioned_clusters_.get(max_index).add_document(d);
        }
    }

    @Override
    public int compareTo(Cluster<K> o) {
        return Double.compare(o.sectioned_gain(), this.sectioned_gain());
    }
}

