/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.LanguageAdapter;
import org.languagetool.gui.LanguageComparator;

class LanguageComboBoxModel
extends DefaultComboBoxModel<LanguageAdapter> {
    private LanguageComboBoxModel() {
    }

    static LanguageComboBoxModel create(ResourceBundle messages, String extLangSuffix, boolean includeHidden, List<Language> external, LanguageAdapter first) {
        LanguageComparator comparator = new LanguageComparator(messages, extLangSuffix);
        LanguageComboBoxModel model = new LanguageComboBoxModel();
        if (first != null) {
            model.addElement(first);
        }
        if (external != null) {
            ArrayList<Language> ext = new ArrayList<Language>(external);
            Collections.sort(ext, comparator);
            for (Language l : ext) {
                model.addElement(new LanguageAdapter(l));
            }
        }
        ArrayList internal = new ArrayList(Languages.get());
        Collections.sort(internal, comparator);
        for (Language l : internal) {
            if (!includeHidden && l.isHiddenFromGui()) continue;
            model.addElement(new LanguageAdapter(l));
        }
        return model;
    }
}

