/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.rules.ngrams.FakeLanguageModel;
import org.languagetool.rules.ngrams.Probability;

public class BaseLanguageModelTest {
    @Test
    public void testPseudoProbability() throws IOException {
        try (FakeLanguageModel lm = new FakeLanguageModel();){
            Probability prob1 = lm.getPseudoProbability(Arrays.asList("no", "data", "here"));
            double delta = 0.001;
            Assert.assertEquals((double)0.0081, (double)prob1.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob1.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.0f)));
            Probability prob2 = lm.getPseudoProbability(Arrays.asList("1", "2", "3", "4"));
            Assert.assertEquals((double)0.0081, (double)prob2.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob2.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.0f)));
            Probability prob3 = lm.getPseudoProbability(Arrays.asList("There", "are"));
            Assert.assertEquals((double)0.082, (double)prob3.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob3.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.5f)));
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPseudoProbabilityFail1() throws IOException {
        try (FakeLanguageModel lm = new FakeLanguageModel();){
            lm.getPseudoProbability(Collections.emptyList());
        }
    }
}

