/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.InMemoryCircuitBreakerRegistry;
import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface CircuitBreakerRegistry
extends Registry<CircuitBreaker, CircuitBreakerConfig> {
    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig);
    }

    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig, registryEventConsumer);
    }

    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig, registryEventConsumers);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs) {
        return CircuitBreakerRegistry.of(configs, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryCircuitBreakerRegistry(configs, tags);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumer);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumer, tags);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumers);
    }

    public static CircuitBreakerRegistry ofDefaults() {
        return new InMemoryCircuitBreakerRegistry();
    }

    public Seq<CircuitBreaker> getAllCircuitBreakers();

    public CircuitBreaker circuitBreaker(String var1);

    public CircuitBreaker circuitBreaker(String var1, io.vavr.collection.Map<String, String> var2);

    public CircuitBreaker circuitBreaker(String var1, CircuitBreakerConfig var2);

    public CircuitBreaker circuitBreaker(String var1, CircuitBreakerConfig var2, io.vavr.collection.Map<String, String> var3);

    public CircuitBreaker circuitBreaker(String var1, String var2);

    public CircuitBreaker circuitBreaker(String var1, String var2, io.vavr.collection.Map<String, String> var3);

    public CircuitBreaker circuitBreaker(String var1, Supplier<CircuitBreakerConfig> var2);

    public CircuitBreaker circuitBreaker(String var1, Supplier<CircuitBreakerConfig> var2, io.vavr.collection.Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore<CircuitBreaker> registryStore;
        private Map<String, CircuitBreakerConfig> circuitBreakerConfigsMap = new java.util.HashMap<String, CircuitBreakerConfig>();
        private List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers = new ArrayList<RegistryEventConsumer<CircuitBreaker>>();
        private io.vavr.collection.Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore<CircuitBreaker> registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withCircuitBreakerConfig(CircuitBreakerConfig circuitBreakerConfig) {
            this.circuitBreakerConfigsMap.put(DEFAULT_CONFIG, circuitBreakerConfig);
            return this;
        }

        public Builder addCircuitBreakerConfig(String configName, CircuitBreakerConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.circuitBreakerConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(io.vavr.collection.Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public CircuitBreakerRegistry build() {
            return new InMemoryCircuitBreakerRegistry(this.circuitBreakerConfigsMap, this.registryEventConsumers, this.tags, this.registryStore);
        }
    }
}

