// file      : libxsd-frontend/version.hxx.in
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef LIBXSD_FRONTEND_VERSION // Note: using the version macro itself.

// The numeric version format is AAAAABBBBBCCCCCDDDE where:
//
// AAAAA - major version number
// BBBBB - minor version number
// CCCCC - bugfix version number
// DDD   - alpha / beta (DDD + 500) version number
// E     - final (0) / snapshot (1)
//
// When DDDE is not 0, 1 is subtracted from AAAAABBBBBCCCCC. For example:
//
// Version      AAAAABBBBBCCCCCDDDE
//
// 0.1.0        0000000001000000000
// 0.1.2        0000000001000020000
// 1.2.3        0000100002000030000
// 2.2.0-a.1    0000200001999990010
// 3.0.0-b.2    0000299999999995020
// 2.2.0-a.1.z  0000200001999990011
//
#define LIBXSD_FRONTEND_VERSION       200001000000000ULL
#define LIBXSD_FRONTEND_VERSION_STR   "2.1.0"
#define LIBXSD_FRONTEND_VERSION_ID    "2.1.0"
#define LIBXSD_FRONTEND_VERSION_FULL  "2.1.0"

#define LIBXSD_FRONTEND_VERSION_MAJOR 2
#define LIBXSD_FRONTEND_VERSION_MINOR 1
#define LIBXSD_FRONTEND_VERSION_PATCH 0

#define LIBXSD_FRONTEND_PRE_RELEASE   false

#define LIBXSD_FRONTEND_SNAPSHOT      0ULL
#define LIBXSD_FRONTEND_SNAPSHOT_ID   ""

#include <xercesc/util/XercesVersion.hpp>

// Check that we have a compatible Xerces version (3.0.0 or later).
//
#if _XERCES_VERSION < 30000
#  error Xerces-C++ 2-series is not supported
#endif

#include <libcutl/version.hxx>

#ifdef LIBCUTL_VERSION
#  if !(LIBCUTL_VERSION >= 100011000000000ULL && LIBCUTL_VERSION < 199999999990001ULL)
#    error incompatible libcutl version, libcutl ^1.11.0 is required
#  endif
#endif

#endif // LIBXSD_FRONTEND_VERSION
