/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import com.google.common.base.Stopwatch;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.models.TModelFilm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.controlsfx.control.RangeSlider;
import org.jetbrains.annotations.NotNull;

public class LuceneGuiFilmeModelHelper
extends GuiModelHelper {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<String, PointsConfig> PARSER_CONFIG_MAP = new HashMap<String, PointsConfig>();

    public LuceneGuiFilmeModelHelper(@NotNull FilmActionPanel filmActionPanel, @NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData) {
        this.filmActionPanel = filmActionPanel;
        this.historyController = historyController;
        this.searchFieldData = searchFieldData;
    }

    private String getFilterThema() {
        String filterThema = (String)this.filmActionPanel.getViewSettingsPane().themaComboBox.getSelectionModel().getSelectedItem();
        if (filterThema == null) {
            filterThema = "";
        }
        return filterThema;
    }

    @Override
    protected boolean noFiltersAreSet() {
        RangeSlider filmLengthSlider = this.filmActionPanel.getFilmLengthSlider();
        return this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().isEmpty() && this.getFilterThema().isEmpty() && this.searchFieldData.isEmpty() && (int)filmLengthSlider.getLowValue() == 0 && (int)filmLengthSlider.getHighValue() == 110 && !this.filmActionPanel.isDontShowAbos() && !this.filmActionPanel.isShowUnseenOnly() && !this.filmActionPanel.isShowOnlyHighQuality() && !this.filmActionPanel.isShowSubtitlesOnly() && !this.filmActionPanel.isShowLivestreamsOnly() && !this.filmActionPanel.isShowNewOnly() && !this.filmActionPanel.isShowBookMarkedOnly() && !this.filmActionPanel.isDontShowTrailers() && !this.filmActionPanel.isDontShowSignLanguage() && !this.filmActionPanel.isDontShowAudioVersions() && ((String)this.filmActionPanel.zeitraumProperty().get()).equalsIgnoreCase("\u221e");
    }

    private TModelFilm performTableFiltering() {
        IndexedFilmList listeFilme = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        try {
            String filterThema;
            Stream<Object> stream;
            List<DatenFilm> resultList;
            this.calculateFilmLengthSliderValues();
            if (this.filmActionPanel.isShowUnseenOnly()) {
                this.historyController.prepareMemoryCache();
            }
            String searchText = this.searchFieldData.searchFieldText();
            if (this.noFiltersAreSet()) {
                resultList = new ArrayList<DatenFilm>(listeFilme);
                stream = resultList.parallelStream();
            } else {
                ObservableList<String> selectedSenders;
                Stopwatch watch2 = Stopwatch.createStarted();
                if (searchText.isEmpty()) {
                    searchText = "*:*";
                }
                StandardAnalyzer analyzer = listeFilme.getAnalyzer();
                StandardQueryParser parser = new StandardQueryParser(analyzer);
                parser.setPointsConfigMap(PARSER_CONFIG_MAP);
                Query initialQuery = parser.parse(searchText, "titel");
                BooleanQuery.Builder qb = new BooleanQuery.Builder();
                qb.add(initialQuery, BooleanClause.Occur.MUST);
                if (!((String)this.filmActionPanel.zeitraumProperty().get()).equals("\u221e")) {
                    try {
                        qb.add(this.createZeitraumQuery(listeFilme), BooleanClause.Occur.FILTER);
                    }
                    catch (Exception ex) {
                        logger.error("Unable to add zeitraum filter", (Throwable)ex);
                    }
                }
                if (this.filmActionPanel.isShowLivestreamsOnly()) {
                    this.addLivestreamQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isShowOnlyHighQuality()) {
                    this.addHighQualityOnlyQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isDontShowTrailers()) {
                    this.addNoTrailerTeaserQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isDontShowAudioVersions()) {
                    this.addNoAudioVersionQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isDontShowSignLanguage()) {
                    this.addNoSignLanguageQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isShowSubtitlesOnly()) {
                    this.addSubtitleOnlyQuery(qb, analyzer);
                }
                if (this.filmActionPanel.isShowNewOnly()) {
                    this.addNewOnlyQuery(qb, analyzer);
                }
                if (!(selectedSenders = this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().getCheckedItems()).isEmpty()) {
                    this.addSenderFilterQuery(qb, analyzer, selectedSenders);
                }
                BooleanQuery finalQuery = qb.build();
                logger.info("Executing Lucene query: {}", (Object)finalQuery.toString());
                IndexSearcher searcher = listeFilme.getIndexSearcher();
                TopDocs docs = searcher.search((Query)finalQuery, Integer.MAX_VALUE);
                ScoreDoc[] hits = docs.scoreDocs;
                watch2.stop();
                logger.trace("Lucene index search took: {}", (Object)watch2);
                HashSet<Integer> filmNrSet = new HashSet<Integer>(hits.length);
                for (ScoreDoc hit : hits) {
                    Document d = searcher.doc(hit.doc);
                    filmNrSet.add(Integer.parseInt(d.get("id")));
                }
                logger.trace("Number of found Lucene index entries: {}", (Object)filmNrSet.size());
                stream = listeFilme.parallelStream().filter(film -> filmNrSet.contains(film.getFilmNr()));
            }
            if (this.filmActionPanel.isShowBookMarkedOnly()) {
                stream = stream.filter(DatenFilm::isBookmarked);
            }
            if (this.filmActionPanel.isDontShowAbos()) {
                stream = stream.filter(film -> film.getAbo() == null);
            }
            if (!(filterThema = this.getFilterThema()).isEmpty()) {
                stream = stream.filter(film -> film.getThema().equalsIgnoreCase(filterThema));
            }
            if (this.maxLength < 110L) {
                stream = stream.filter(this::maxLengthCheck);
            }
            if (this.filmActionPanel.isShowUnseenOnly()) {
                stream = stream.filter(this::seenCheck);
            }
            stream = stream.filter(this::minLengthCheck);
            resultList = stream.collect(Collectors.toList());
            stream.close();
            TModelFilm filmModel = new TModelFilm(resultList.size());
            filmModel.addAll(resultList);
            resultList.clear();
            if (this.filmActionPanel.isShowUnseenOnly()) {
                this.historyController.emptyMemoryCache();
            }
            return filmModel;
        }
        catch (Exception ex) {
            logger.error("Lucene filtering failed!", (Throwable)ex);
            SwingUtilities.invokeLater(() -> SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Die Lucene Abfrage ist inkorrekt und f\u00fchrt zu keinen Ergebnissen.", ex));
            return new TModelFilm();
        }
    }

    private void addSenderFilterQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer, @NotNull List<String> selectedSenders) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("+(");
        for (String sender : selectedSenders) {
            sb.append("sender:");
            sb.append(sender);
            sb.append(" ");
        }
        sb.append(")");
        Query q = new QueryParser("sender", analyzer).parse(sb.toString());
        qb.add(q, BooleanClause.Occur.FILTER);
    }

    private void addSubtitleOnlyQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("untertitel", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.FILTER);
    }

    private void addNoSignLanguageQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("signlanguage", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNoAudioVersionQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("audioversion", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNoTrailerTeaserQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("trailerteaser", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNewOnlyQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("neu", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.FILTER);
    }

    private void addLivestreamQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("livestream", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.FILTER);
    }

    private void addHighQualityOnlyQuery(@NotNull BooleanQuery.Builder qb, @NotNull StandardAnalyzer analyzer) throws ParseException {
        Query q = new QueryParser("highquality", analyzer).parse("\"true\"");
        qb.add(q, BooleanClause.Occur.FILTER);
    }

    private Query createZeitraumQuery(@NotNull IndexedFilmList listeFilme) throws ParseException {
        int numDays = Integer.parseInt((String)this.filmActionPanel.zeitraumProperty().get());
        LocalDateTime to_Date = LocalDateTime.now();
        LocalDateTime from_Date = to_Date.minusDays(numDays);
        ZoneId utcZone = ZoneId.of("UTC");
        String toStr = DateTools.timeToString(to_Date.atZone(utcZone).toInstant().toEpochMilli(), DateTools.Resolution.DAY);
        String fromStr = DateTools.timeToString(from_Date.atZone(utcZone).toInstant().toEpochMilli(), DateTools.Resolution.DAY);
        String zeitraum = String.format("[%s TO %s]", fromStr, toStr);
        return new QueryParser("sendedatum", listeFilme.getAnalyzer()).parse(zeitraum);
    }

    @Override
    public TableModel getFilteredTableModel() {
        TModelFilm filmModel;
        IndexedFilmList listeFilme = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        if (!listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                filmModel = new TModelFilm(listeFilme.size());
                filmModel.addAll(listeFilme);
            } else {
                filmModel = this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return filmModel;
    }

    static {
        PARSER_CONFIG_MAP.put("gr\u00f6\u00dfe", new PointsConfig(new DecimalFormat(), Integer.class));
        PARSER_CONFIG_MAP.put("l\u00e4nge", new PointsConfig(new DecimalFormat(), Integer.class));
    }
}

